/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.common.Lock;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.exception.ObjectNotFoundException;
import ru.interunity.eyprint.ps.exception.QueueException;
import ru.interunity.eyprint.ps.proc.PrintProcessor;
import ru.interunity.eyprint.ps.proc.Printer;
import ru.interunity.eyprint.ps.proc.PrinterHolder;
import ru.interunity.eyprint.ps.servces.ConverterSrv;
import ru.interunity.eyprint.ps.servces.ConvertingStack;
import ru.interunity.eyprint.ps.servces.PrintJobWriter;
import ru.interunity.eyprint.ps.servces.PrintServerContext;
import ru.interunity.eyprint.ps.ui.PrintJobTableModel;
import ru.interunity.eyprint.ps.util.PrintQueue;
import ru.interunity.eyprint.ps.util.PrintQueueWithTableModel;
import ru.interunity.eyprint.ps.util.QueuedPrintJob;
import ru.interunity.eyprint.ps.util.QueuedPrintJobInfo;
import ru.interunity.eyprint.ps.util.StringUtil;
import ru.linologi.core.scp.srv.ParamLoadSrv;

public class Queues {
    static Logger log = LoggerFactory.getLogger(Queues.class);
    private static final Queues INSTANCE = new Queues();
    private final Hashtable<String, PrintQueue> queues = new Hashtable();
    ParamLoadSrv paramLoadSrv = (ParamLoadSrv)PrintServerContext.getBean(ParamLoadSrv.class);

    private Queues() {
        log.debug("Queues(): STARTED");
    }

    public static Queues getInstance() {
        return INSTANCE;
    }

    public void createQueue(String queueName, Printer printer) throws QueueException {
        if (StringUtil.isEmpty((String)queueName)) {
            throw new QueueException("queueName passed in was empty.");
        }
        if (this.queues.containsKey(queueName)) {
            throw new QueueException("the queue called(" + queueName + ") already exists.");
        }
        PrintQueue createdQueue = new PrintQueue(queueName);
        if (printer != null) {
            Thread printProc = new Thread((Runnable)new PrintProcessor(createdQueue), "Print-Proc-" + queueName);
            PrinterHolder.newPrinter((PrintQueue)createdQueue, (Printer)printer);
            printProc.start();
        }
        this.queues.put(queueName, createdQueue);
    }

    public PrintQueue createQueueWithTableModel(String queueName, PrintJobTableModel tableModel) throws QueueException {
        if (StringUtil.isEmpty((String)queueName)) {
            throw new QueueException("queueName passed in was empty.");
        }
        if (this.queues.containsKey(queueName)) {
            throw new QueueException("the queue called(" + queueName + ") already exists.");
        }
        PrintQueueWithTableModel queue = new PrintQueueWithTableModel(queueName, tableModel);
        this.queues.put(queueName, queue);
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJob(String queueName, PrintJob printJob) throws QueueException {
        if (StringUtil.isEmpty((String)queueName)) {
            log.error("queueName passed in was empty.");
            throw new QueueException("queueName passed in was empty.");
        }
        if (!this.queues.containsKey(queueName)) {
            log.error("the queue called(" + queueName + ") does not exist.");
            throw new QueueException("the queue called(" + queueName + ") does not exist.");
        }
        if (null == printJob) {
            log.error("PrintJob passed in was null.");
            throw new QueueException("PrintJob passed in was null.");
        }
        if (null == printJob.getDataFile()) {
            log.error("DataFile in PrintJob passed in was null.");
            throw new QueueException("DataFile in PrintJob passed in was null.");
        }
        if (null == printJob.getDataFile().getContents()) {
            log.error("contents of DataFile in PrintJob passed in was null.");
            throw new QueueException("contents of DataFile in PrintJob passed in was null.");
        }
        PrintQueue queue = (PrintQueue)this.queues.get(queueName);
        log.debug("got queue: " + queueName);
        Lock lock = queue.getLock();
        log.debug("got lock for queue: " + queueName);
        try {
            PrintJobWriter dbWriter = (PrintJobWriter)PrintServerContext.getBean(PrintJobWriter.class);
            ParamLoadSrv paramLoadSrv = (ParamLoadSrv)PrintServerContext.getBean(ParamLoadSrv.class);
            try {
                ConverterSrv.init();
                printJob.setPdfPath(printJob.getEyeprintJobId() + ".pdf");
            }
            catch (Exception e) {
                log.error("Error create pdf file from ps", (Throwable)e);
            }
            dbWriter.writeNewJob(printJob);
            File fl = new File(paramLoadSrv.getStringParam("eyeprint.ps.jobstorage") + printJob.getEyeprintJobId() + ".ps");
            FileOutputStream write = new FileOutputStream(fl);
            write.write(printJob.getDataFile().getContents());
            write.flush();
            write.close();
            ConvertingStack.put((Long)printJob.getEyeprintJobId().longValue(), (String)fl.getAbsolutePath());
        }
        catch (Exception e) {
            log.info("Can not write data to file");
            log.error("I got error% ", (Throwable)e);
        }
        Lock lock2 = lock;
        synchronized (lock2) {
            queue.add(printJob);
            lock.notifyAll();
            log.debug("sent notify all to Lock object for queue: " + queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePrintJob(String queueName, String user, String jobNumber) throws QueueException {
        long jobId;
        if (StringUtil.isEmpty((String)queueName)) {
            log.error("queueName passed in was empty.");
            throw new QueueException("queueName passed in was empty.");
        }
        if (!this.queues.containsKey(queueName)) {
            log.error("the queue called(" + queueName + ") does not exist.");
            throw new QueueException("the queue called(" + queueName + ") does not exist.");
        }
        if (StringUtil.isEmpty((String)user)) {
            log.error("user passed in was empty.");
            throw new QueueException("user passed in was empty.");
        }
        if (StringUtil.isEmpty((String)jobNumber)) {
            log.error("PrintJob passed in was empty.");
            throw new QueueException("PrintJob passed in was empty.");
        }
        try {
            jobId = Long.parseLong(jobNumber);
        }
        catch (NumberFormatException e) {
            log.warn("The jobNumber(" + jobNumber + ") passed in was not a number: ");
            log.error(e.getMessage());
            throw new QueueException(e.getMessage());
        }
        PrintQueue queue = (PrintQueue)this.queues.get(queueName);
        Lock lock = queue.getLock();
        try {
            if ("root".equals(user.trim()) || "Administrator".equalsIgnoreCase(user.trim())) {
                Lock lock2 = lock;
                synchronized (lock2) {
                    queue.remove(jobId);
                    return;
                }
            }
            List jobs = queue.list();
            Iterator iterator = jobs.iterator();
            while (iterator.hasNext()) {
                String jobOwner;
                QueuedPrintJobInfo qpji = (QueuedPrintJobInfo)iterator.next();
                if (qpji.getId() != jobId || null == (jobOwner = qpji.getOwner()) || !jobOwner.trim().equals(user.trim())) continue;
                Lock lock3 = lock;
                synchronized (lock3) {
                    queue.remove(jobId);
                }
            }
            return;
        }
        catch (ObjectNotFoundException e) {
            log.error(e.getMessage());
            throw new QueueException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPrintJobs(String queueName) throws QueueException {
        Lock lock;
        if (StringUtil.isEmpty((String)queueName)) {
            log.error("queueName passed in was empty.");
            throw new QueueException("queueName passed in was empty.");
        }
        if (!this.queues.containsKey(queueName)) {
            log.error("the queue called(" + queueName + ") does not exist.");
            throw new QueueException("the queue called(" + queueName + ") does not exist.");
        }
        PrintQueue queue = (PrintQueue)this.queues.get(queueName);
        Lock lock2 = lock = queue.getLock();
        synchronized (lock2) {
            queue.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueuedPrintJobInfo> listAllPrintJobs(String queueName) throws QueueException {
        List result;
        Lock lock;
        if (StringUtil.isEmpty((String)queueName)) {
            log.error("queueName passed in was empty.");
            throw new QueueException("queueName passed in was empty.");
        }
        if (!this.queues.containsKey(queueName)) {
            log.error("the queue called(" + queueName + ") does not exist.");
            throw new QueueException("the queue called(" + queueName + ") does not exist.");
        }
        PrintQueue queue = (PrintQueue)this.queues.get(queueName);
        Lock lock2 = lock = queue.getLock();
        synchronized (lock2) {
            result = queue.list();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize(String queueName) throws QueueException {
        Lock lock;
        int result = -1;
        if (StringUtil.isEmpty((String)queueName)) {
            log.error("queueName passed in was empty.");
            throw new QueueException("queueName passed in was empty.");
        }
        if (!this.queues.containsKey(queueName)) {
            log.error("the queue called(" + queueName + ") does not exist.");
            throw new QueueException("the queue called(" + queueName + ") does not exist.");
        }
        PrintQueue queue = (PrintQueue)this.queues.get(queueName);
        Lock lock2 = lock = queue.getLock();
        synchronized (lock2) {
            result = queue.size();
        }
        return result;
    }

    public Lock getQueueLock(String queueName) throws QueueException {
        if (StringUtil.isEmpty((String)queueName)) {
            log.error("queueName passed in was empty.");
            throw new QueueException("queueName passed in was empty.");
        }
        if (!this.queues.containsKey(queueName)) {
            log.error("the queue called(" + queueName + ") does not exist.");
            throw new QueueException("the queue called(" + queueName + ") does not exist.");
        }
        PrintQueue queue = (PrintQueue)this.queues.get(queueName);
        Lock result = queue.getLock();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedPrintJob getNextPrintJob(String queueName) throws QueueException {
        QueuedPrintJob result;
        if (StringUtil.isEmpty((String)queueName)) {
            log.error("queueName passed in was empty.");
            throw new QueueException("queueName passed in was empty.");
        }
        if (!this.queues.containsKey(queueName)) {
            log.error("the queue called(" + queueName + ") does not exist.");
            throw new QueueException("the queue called(" + queueName + ") does not exist.");
        }
        PrintQueue queue = (PrintQueue)this.queues.get(queueName);
        Lock lock = queue.getLock();
        try {
            Lock lock2 = lock;
            synchronized (lock2) {
                result = queue.getNextPrintJob();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new QueueException((Throwable)e);
        }
        return result;
    }

    public static Map<String, PrintQueue> getQueues() {
        HashMap<String, PrintQueue> listOfQueue = new HashMap<String, PrintQueue>();
        Hashtable proc = Queues.INSTANCE.queues;
        proc.forEach((key, value) -> listOfQueue.put((String)key, (PrintQueue)proc.get(key)));
        return listOfQueue;
    }
}

