/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.ep.dto.JobPriceDto;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.proc.Printer;

public class JobUtil {
    private static final Logger log = LoggerFactory.getLogger(JobUtil.class);

    public static Integer findPageCount(String psFile) {
        Pattern pattern = Pattern.compile("%%Pages: \\d+");
        Matcher matcher = pattern.matcher(psFile);
        if (!matcher.find()) {
            return null;
        }
        String find = matcher.group();
        pattern = Pattern.compile("\\d+");
        matcher = pattern.matcher(find);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        return null;
    }

    public static String getPrintFormat(String psFile) {
        Pattern pattern = Pattern.compile("%%BeginFeature: \\*PageSize (.*?)(?:$|\\s|\\r|\\n)");
        Matcher matcher = pattern.matcher(psFile);
        if (matcher.find()) {
            return matcher.group().replace("%%BeginFeature: *PageSize ", "").trim();
        }
        return null;
    }

    public static Double getJobPrice(PrintJob job, List<JobPriceDto> price, Integer modelId, Integer color) {
        if (job.getPageCount() == null) {
            return 0.0;
        }
        Double resultPrice = 0.0;
        try {
            for (JobPriceDto p : price) {
                if (job.getEyeprintPrinterId() == p.getPrinterId().longValue()) {
                    if (modelId.intValue() != p.getModel().intValue() || !job.getPrintFormat().contains(p.getFormat()) || p.getColor() < color) continue;
                    resultPrice = p.getPrice();
                    return resultPrice;
                }
                if (modelId != p.getModel() || !job.getPrintFormat().contains(p.getFormat()) || p.getColor() < color) continue;
                resultPrice = p.getPrice();
            }
        }
        catch (Exception ex) {
            log.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442\u043f\u0435\u0447\u0430\u0442\u043a\u0430", (Throwable)ex);
        }
        return resultPrice * (double)job.getPageCount().intValue();
    }

    public static Integer checkResultJobColor(Printer printer, String content) {
        return printer.getColor() > 1 && !content.contains("%%BeginFeature: *OKControl Gray") ? 4 : 1;
    }

    public static Boolean isJobContentColor(String content) {
        return !content.contains("%%BeginFeature: *OKControl Gray");
    }

    public static Boolean isJobDuplex(String jobContens) {
        return jobContens.contains("/Duplex true");
    }
}

