/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    static Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final String METHOD_writeFile = "writeFile(): ";
    private static final String METHOD_deleteFiles = "deleteFiles(): ";
    private static final String METHOD_runProgram = "runProgram(): ";
    private static final String METHOD_readInputStream = "readInputStream(): ";
    private static final String STARTED = "started.";
    private static final String FINISHED = "finished.";
    private static final String ERROR = "**ERROR** ";

    public static File writeFile(InputStream inputStream, String filename) throws IOException {
        log.debug("writeFile(): started.");
        File result = null;
        int byteCount = -1;
        byte[] data = new byte[1024];
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filename));
        while ((byteCount = bis.read(data, 0, 1024)) > -1) {
            bos.write(data, 0, byteCount);
        }
        bos.flush();
        if (null != bos) {
            try {
                bos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null != bis) {
            try {
                bis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        result = new File(filename);
        return result;
    }

    public static File writeFile(String data, String filename) throws IOException {
        File result = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes());
        result = FileUtil.writeFile((InputStream)bais, (String)filename);
        if (null != bais) {
            try {
                bais.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static File writeFile(byte[] data, String filename) throws IOException {
        File result = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        result = FileUtil.writeFile((InputStream)bais, (String)filename);
        if (null != bais) {
            try {
                bais.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static void deleteFiles(String[] filenames) {
        for (int i = 0; i < filenames.length; ++i) {
            FileUtil.deleteFile((String)filenames[i]);
        }
    }

    public static void deleteFile(String filename) {
        File file = new File(filename);
        try {
            if (file.delete()) {
                log.debug("deleteFiles(): " + filename + " was successfully deleted");
            } else {
                log.error("deleteFiles(): Error deleting \"" + filename + "\"");
            }
        }
        catch (SecurityException e) {
            log.error("deleteFiles(): Error deleting \"" + filename + "\"");
            log.error("deleteFiles(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void deleteFile(File filename) {
        try {
            if (filename.delete()) {
                log.debug("deleteFiles(): " + filename + " was successfully deleted");
            } else {
                log.error("deleteFiles(): Error deleting \"" + filename + "\"");
            }
        }
        catch (SecurityException e) {
            log.error("deleteFiles(): Error deleting \"" + filename + "\"");
            log.error("deleteFiles(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runProgram(String program, ByteArrayOutputStream baos) {
        int result = -1;
        InputStream is = null;
        try {
            Process proc = Runtime.getRuntime().exec(program);
            is = proc.getInputStream();
            FileUtil.readInputStream((InputStream)is, (ByteArrayOutputStream)baos);
            result = proc.waitFor();
        }
        catch (InterruptedException e) {
            log.error("runProgram(): " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error("runProgram(): " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public static String inputStream2String(InputStream is) {
        String result = new String();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtil.readInputStream((InputStream)is, (ByteArrayOutputStream)baos);
        result = baos.toString();
        if (null != baos) {
            try {
                baos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static ByteArrayOutputStream inputStream2ByteArray(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtil.readInputStream((InputStream)is, (ByteArrayOutputStream)baos);
        return baos;
    }

    public static void readInputStream(InputStream is, ByteArrayOutputStream baos) {
        int data = -1;
        try {
            while (-1 != (data = is.read())) {
                baos.write(data);
            }
        }
        catch (IOException e) {
            log.error("readInputStream(): " + e.getMessage());
            e.printStackTrace();
        }
    }
}

