/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.proc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.proc.Printer;

public class PrinterImpl
implements Printer {
    private boolean ready = true;
    private final String ip;
    private final long printerId;
    private Integer color;
    private String format;
    private Integer model;

    public PrinterImpl(String ip, long printerId) {
        this.ip = ip;
        this.printerId = printerId;
    }

    public void print(PrintJob job) throws IOException {
        Socket clientSocket = new Socket(this.ip, 9100);
        OutputStream out = clientSocket.getOutputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
        out.write(job.getDataFile().getContents());
        in.close();
        out.close();
        clientSocket.close();
    }

    public long getPrinterId() {
        return this.printerId;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void block() {
        this.ready = false;
    }

    public String getIp() {
        return this.ip;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer color) {
        this.color = color;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Integer getModel() {
        return this.model;
    }

    public void setModel(Integer model) {
        this.model = model;
    }
}

