/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.ep.utils.StringDecodeUtils;
import ru.interunity.eyprint.ps.exception.LPDException;
import ru.interunity.eyprint.ps.util.StringUtil;

public class ControlFileCommands
implements Serializable,
Cloneable {
    static Logger log = LoggerFactory.getLogger(ControlFileCommands.class);
    private String classForBannerPage;
    private String host;
    private String indentCount;
    private String jobName;
    private String userName;
    private String email;
    private String fileName;
    private String userId;
    private String symbolicLinkData;
    private String title;
    private String fileToUnlink;
    private String widthCount;
    private String troffRFontFileName;
    private String troffIFontName;
    private String troffBFontName;
    private String troffSFontName;
    private String plotCIFFileName;
    private String printDVIFileName;
    private String fileToPrintAsText;
    private String fileToPlot;
    private String fileToPrintAsTextRaw;
    private String fileToPrintAsDitroff;
    private String fileToPrintAsPostscript;
    private String fileToPrintAsPr;
    private String fileToPrintFortran;
    private String fileToPrintAsTroff;
    private String fileToPrintAsRaster;

    public ControlFileCommands() {
    }

    public ControlFileCommands(String classForBannerPage, String host, String indentCount, String jobName, String userName, String email, String fileName, String userId, String symbolicLinkData, String title, String fileToUnlink, String widthCount, String troffRFontFileName, String troffIFontName, String troffBFontName, String troffSFontName, String plotCIFFileName, String printDVIFileName, String fileToPrintAsText, String fileToPlot, String fileToPrintAsTextRaw, String fileToPrintAsDitroff, String fileToPrintAsPostscript, String fileToPrintAsPr, String fileToPrintFortran, String fileToPrintAsTroff, String fileToPrintAsRaster) {
        this.classForBannerPage = classForBannerPage;
        this.host = host;
        this.indentCount = indentCount;
        this.jobName = jobName;
        this.userName = userName;
        this.email = email;
        this.fileName = fileName;
        this.userId = userId;
        this.symbolicLinkData = symbolicLinkData;
        this.title = title;
        this.fileToUnlink = fileToUnlink;
        this.widthCount = widthCount;
        this.troffRFontFileName = troffRFontFileName;
        this.troffIFontName = troffIFontName;
        this.troffBFontName = troffBFontName;
        this.troffSFontName = troffSFontName;
        this.plotCIFFileName = plotCIFFileName;
        this.printDVIFileName = printDVIFileName;
        this.fileToPrintAsText = fileToPrintAsText;
        this.fileToPlot = fileToPlot;
        this.fileToPrintAsTextRaw = fileToPrintAsTextRaw;
        this.fileToPrintAsDitroff = fileToPrintAsDitroff;
        this.fileToPrintAsPostscript = fileToPrintAsPostscript;
        this.fileToPrintAsPr = fileToPrintAsPr;
        this.fileToPrintFortran = fileToPrintFortran;
        this.fileToPrintAsTroff = fileToPrintAsTroff;
        this.fileToPrintAsRaster = fileToPrintAsRaster;
    }

    public String getClassForBannerPage() {
        return this.classForBannerPage;
    }

    public String getHost() {
        return this.host;
    }

    public String getIndentCount() {
        return this.indentCount;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSymbolicLinkData() {
        return this.symbolicLinkData;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFileToUnlink() {
        return this.fileToUnlink;
    }

    public String getWidthCount() {
        return this.widthCount;
    }

    public String getTroffRFontFileName() {
        return this.troffRFontFileName;
    }

    public String getTroffIFontName() {
        return this.troffIFontName;
    }

    public String getTroffBFontName() {
        return this.troffBFontName;
    }

    public String getTroffSFontName() {
        return this.troffSFontName;
    }

    public String getPlotCIFFileName() {
        return this.plotCIFFileName;
    }

    public String getPrintDVIFileName() {
        return this.printDVIFileName;
    }

    public String getFileToPrintAsText() {
        return this.fileToPrintAsText;
    }

    public String getFileToPlot() {
        return this.fileToPlot;
    }

    public String getFileToPrintAsTextRaw() {
        return this.fileToPrintAsTextRaw;
    }

    public String getFileToPrintAsDitroff() {
        return this.fileToPrintAsDitroff;
    }

    public String getFileToPrintAsPostscript() {
        return this.fileToPrintAsPostscript;
    }

    public String getFileToPrintAsPr() {
        return this.fileToPrintAsPr;
    }

    public String getFileToPrintFortran() {
        return this.fileToPrintFortran;
    }

    public String getFileToPrintAsTroff() {
        return this.fileToPrintAsTroff;
    }

    public String getFileToPrintAsRaster() {
        return this.fileToPrintAsRaster;
    }

    public void setClassForBannerPage(String a) {
        this.classForBannerPage = a;
    }

    public void setHost(String a) {
        this.host = a;
    }

    public void setIndentCount(String a) {
        this.indentCount = a;
    }

    public void setJobName(String a) {
        this.jobName = a;
    }

    public void setUserName(String a) {
        this.userName = a;
    }

    public void setEmail(String a) {
        this.email = a;
    }

    public void setFileName(String a) {
        this.fileName = a;
    }

    public void setUserId(String a) {
        this.userId = a;
    }

    public void setSymbolicLinkData(String a) {
        this.symbolicLinkData = a;
    }

    public void setTitle(String a) {
        this.title = a;
    }

    public void setFileToUnlink(String a) {
        this.fileToUnlink = a;
    }

    public void setWidthCount(String a) {
        this.widthCount = a;
    }

    public void setTroffRFontFileName(String a) {
        this.troffRFontFileName = a;
    }

    public void setTroffIFontName(String a) {
        this.troffIFontName = a;
    }

    public void setTroffBFontName(String a) {
        this.troffBFontName = a;
    }

    public void setTroffSFontName(String a) {
        this.troffSFontName = a;
    }

    public void setPlotCIFFileName(String a) {
        this.plotCIFFileName = a;
    }

    public void setPrintDVIFileName(String a) {
        this.printDVIFileName = a;
    }

    public void setFileToPrintAsText(String a) {
        this.fileToPrintAsText = a;
    }

    public void setFileToPlot(String a) {
        this.fileToPlot = a;
    }

    public void setFileToPrintAsTextRaw(String a) {
        this.fileToPrintAsTextRaw = a;
    }

    public void setFileToPrintAsDitroff(String a) {
        this.fileToPrintAsDitroff = a;
    }

    public void setFileToPrintAsPostscript(String a) {
        this.fileToPrintAsPostscript = a;
    }

    public void setFileToPrintAsPr(String a) {
        this.fileToPrintAsPr = a;
    }

    public void setFileToPrintFortran(String a) {
        this.fileToPrintFortran = a;
    }

    public void setFileToPrintAsTroff(String a) {
        this.fileToPrintAsTroff = a;
    }

    public void setFileToPrintAsRaster(String a) {
        this.fileToPrintAsRaster = a;
    }

    public Object clone() {
        String METHOD_NAME = "clone()";
        Object result = null;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error("clone()" + e.getMessage());
            throw new InternalError("clone()" + e.getMessage());
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("classForBannerPage = ");
        sb.append(this.classForBannerPage);
        sb.append(", ");
        sb.append("host = ");
        sb.append(this.host);
        sb.append(", ");
        sb.append("indentCount = ");
        sb.append(this.indentCount);
        sb.append(", ");
        sb.append("jobName = ");
        sb.append(this.jobName);
        sb.append(", ");
        sb.append("userName = ");
        sb.append(this.userName);
        sb.append(", ");
        sb.append("email = ");
        sb.append(this.email);
        sb.append(", ");
        sb.append("fileName = ");
        sb.append(this.fileName);
        sb.append(", ");
        sb.append("userId = ");
        sb.append(this.userId);
        sb.append(", ");
        sb.append("symbolicLinkData = ");
        sb.append(this.symbolicLinkData);
        sb.append(", ");
        sb.append("title = ");
        sb.append(this.title);
        sb.append(", ");
        sb.append("fileToUnlink = ");
        sb.append(this.fileToUnlink);
        sb.append(", ");
        sb.append("widthCount = ");
        sb.append(this.widthCount);
        sb.append(", ");
        sb.append("troffRFontFileName = ");
        sb.append(this.troffRFontFileName);
        sb.append(", ");
        sb.append("troffIFontName = ");
        sb.append(this.troffIFontName);
        sb.append(", ");
        sb.append("troffBFontName = ");
        sb.append(this.troffBFontName);
        sb.append(", ");
        sb.append("troffSFontName = ");
        sb.append(this.troffSFontName);
        sb.append(", ");
        sb.append("plotCIFFileName = ");
        sb.append(this.plotCIFFileName);
        sb.append(", ");
        sb.append("printDVIFileName = ");
        sb.append(this.printDVIFileName);
        sb.append(", ");
        sb.append("fileToPrintAsText = ");
        sb.append(this.fileToPrintAsText);
        sb.append(", ");
        sb.append("fileToPlot = ");
        sb.append(this.fileToPlot);
        sb.append(", ");
        sb.append("fileToPrintAsTextRaw = ");
        sb.append(this.fileToPrintAsTextRaw);
        sb.append(", ");
        sb.append("fileToPrintAsDitroff = ");
        sb.append(this.fileToPrintAsDitroff);
        sb.append(", ");
        sb.append("fileToPrintAsPostscript = ");
        sb.append(this.fileToPrintAsPostscript);
        sb.append(", ");
        sb.append("fileToPrintAsPr = ");
        sb.append(this.fileToPrintAsPr);
        sb.append(", ");
        sb.append("fileToPrintFortran = ");
        sb.append(this.fileToPrintFortran);
        sb.append(", ");
        sb.append("fileToPrintAsTroff = ");
        sb.append(this.fileToPrintAsTroff);
        sb.append(", ");
        sb.append("fileToPrintAsRaster = ");
        sb.append(this.fileToPrintAsRaster);
        return sb.toString();
    }

    public ControlFileCommands(byte[] bytes) throws LPDException {
        String METHOD_NAME = "ControlFileCommands(): ";
        try {
            String line;
            String decoded = StringDecodeUtils.detectAndConvertToUtf8((byte[])bytes);
            ArrayList<String> commandsDecoded = new ArrayList<String>();
            try {
                String[] lines = decoded.split("\n");
                commandsDecoded.addAll(Arrays.asList(lines));
            }
            catch (Exception ex) {
                log.error("ControlFileCommands(): " + ex.getMessage());
            }
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(bytes);
            InputStreamReader inputstreamreader = new InputStreamReader(bytearrayinputstream);
            BufferedReader bufferedReader = new BufferedReader(inputstreamreader);
            Iterator iter = commandsDecoded.iterator();
            while ((line = bufferedReader.readLine()) != null) {
                String original = null;
                try {
                    original = (String)iter.next();
                }
                catch (Exception ex) {
                    log.error("ControlFileCommands(): " + ex.getMessage());
                }
                this.processCommand(line + "\n", original);
                log.info("--->>>{}", (Object)original);
            }
        }
        catch (Exception e) {
            log.error("ControlFileCommands(): " + e.getMessage());
            throw new LPDException((Throwable)e);
        }
    }

    protected void processCommand(String command, String original) {
        Vector vector = StringUtil.parseCommand((byte[])command.getBytes());
        String commandCode = new String((byte[])vector.get(0));
        String operand = new String((byte[])vector.get(1));
        if (commandCode.equals("N")) {
            StringBuffer sb = new StringBuffer();
            vector.stream().skip(1L).forEach(el -> sb.append(" " + new String((byte[])el)));
            operand = sb.toString().trim();
        }
        this.setAttribute(commandCode, operand, original);
    }

    protected void setAttribute(String commandcode, String operand, String original) {
        if (commandcode != null) {
            if (commandcode.equals("C")) {
                this.setClassForBannerPage(operand);
            } else if (commandcode.equals("H")) {
                this.setHost(operand);
            } else if (commandcode.equals("I")) {
                this.setIndentCount(operand);
            } else if (commandcode.equals("J")) {
                this.setJobName(operand);
            } else if (commandcode.equals("L")) {
                this.setUserName(operand);
            } else if (commandcode.equals("M")) {
                this.setEmail(operand);
            } else if (commandcode.equals("N")) {
                if (original != null) {
                    this.setFileName(original.substring(1));
                } else {
                    this.setFileName(operand);
                }
            } else if (commandcode.equals("P")) {
                this.setUserId(operand);
            } else if (commandcode.equals("S")) {
                this.setSymbolicLinkData(operand);
            } else if (commandcode.equals("T")) {
                this.setTitle(operand);
            } else if (commandcode.equals("U")) {
                this.setFileToUnlink(operand);
            } else if (commandcode.equals("W")) {
                this.setWidthCount(operand);
            } else if (commandcode.equals("1")) {
                this.setTroffRFontFileName(operand);
            } else if (commandcode.equals("2")) {
                this.setTroffIFontName(operand);
            } else if (commandcode.equals("3")) {
                this.setTroffBFontName(operand);
            } else if (commandcode.equals("4")) {
                this.setTroffSFontName(operand);
            } else if (commandcode.equals("c")) {
                this.setPlotCIFFileName(operand);
            } else if (commandcode.equals("d")) {
                this.setPrintDVIFileName(operand);
            } else if (commandcode.equals("f")) {
                this.setFileToPrintAsText(operand);
            } else if (commandcode.equals("g")) {
                this.setFileToPlot(operand);
            } else if (commandcode.equals("l")) {
                this.setFileToPrintAsTextRaw(operand);
            } else if (commandcode.equals("n")) {
                this.setFileToPrintAsDitroff(operand);
            } else if (commandcode.equals("o")) {
                this.setFileToPrintAsPostscript(operand);
            } else if (commandcode.equals("p")) {
                this.setFileToPrintAsPr(operand);
            } else if (commandcode.equals("r")) {
                this.setFileToPrintFortran(operand);
            } else if (commandcode.equals("t")) {
                this.setFileToPrintAsTroff(operand);
            } else if (commandcode.equals("v")) {
                this.setFileToPrintAsRaster(operand);
            }
        }
    }

    public static void main(String[] args) throws LPDException {
        String controlfile = new String("CClass\nHHost\nIcount\nJJob name\nLUser\nMuser\nNName\nPName\nSdevice inode\nTtitle\nUfile\nWwidth\n1file\n2file\n3file\n4file\ncfile\ndfile\nffile\ngfile\nlfile\nnfile\nofile\npfile\nrfile\ntfile\nvfile\n");
        byte[] bytes = controlfile.getBytes();
        ControlFileCommands controlfilecommands = new ControlFileCommands(bytes);
        System.out.println("controlfilecommands[" + controlfilecommands + "]");
    }

    public byte[] toControlFileFormat() {
        StringBuffer stringbuffer = new StringBuffer();
        String attribute = this.getClassForBannerPage();
        if (attribute != null) {
            stringbuffer.append("C").append(attribute);
        }
        if ((attribute = this.getHost()) != null) {
            stringbuffer.append("H").append(attribute);
        }
        if ((attribute = this.getIndentCount()) != null) {
            stringbuffer.append("I").append(attribute);
        }
        if ((attribute = this.getJobName()) != null) {
            stringbuffer.append("J").append(attribute);
        }
        if ((attribute = this.getUserName()) != null) {
            stringbuffer.append("L").append(attribute);
        }
        if ((attribute = this.getEmail()) != null) {
            stringbuffer.append("M").append(attribute);
        }
        if ((attribute = this.getFileName()) != null) {
            stringbuffer.append("N").append(attribute);
        }
        if ((attribute = this.getUserId()) != null) {
            stringbuffer.append("P").append(attribute);
        }
        if ((attribute = this.getSymbolicLinkData()) != null) {
            stringbuffer.append("S").append(attribute);
        }
        if ((attribute = this.getTitle()) != null) {
            stringbuffer.append("T").append(attribute);
        }
        if ((attribute = this.getFileToUnlink()) != null) {
            stringbuffer.append("U").append(attribute);
        }
        if ((attribute = this.getWidthCount()) != null) {
            stringbuffer.append("W").append(attribute);
        }
        if ((attribute = this.getTroffRFontFileName()) != null) {
            stringbuffer.append("1").append(attribute);
        }
        if ((attribute = this.getTroffIFontName()) != null) {
            stringbuffer.append("2").append(attribute);
        }
        if ((attribute = this.getTroffBFontName()) != null) {
            stringbuffer.append("3").append(attribute);
        }
        if ((attribute = this.getTroffSFontName()) != null) {
            stringbuffer.append("4").append(attribute);
        }
        if ((attribute = this.getPlotCIFFileName()) != null) {
            stringbuffer.append("c").append(attribute);
        }
        if ((attribute = this.getPrintDVIFileName()) != null) {
            stringbuffer.append("d").append(attribute);
        }
        if ((attribute = this.getFileToPrintAsText()) != null) {
            stringbuffer.append("f").append(attribute);
        }
        if ((attribute = this.getFileToPlot()) != null) {
            stringbuffer.append("g").append(attribute);
        }
        if ((attribute = this.getFileToPrintAsTextRaw()) != null) {
            stringbuffer.append("l").append(attribute);
        }
        if ((attribute = this.getFileToPrintAsDitroff()) != null) {
            stringbuffer.append("n").append(attribute);
        }
        if ((attribute = this.getFileToPrintAsPostscript()) != null) {
            stringbuffer.append("o").append(attribute);
        }
        if ((attribute = this.getFileToPrintAsPr()) != null) {
            stringbuffer.append("p").append(attribute);
        }
        if ((attribute = this.getFileToPrintFortran()) != null) {
            stringbuffer.append("r").append(attribute);
        }
        if ((attribute = this.getFileToPrintAsTroff()) != null) {
            stringbuffer.append("t").append(attribute);
        }
        if ((attribute = this.getFileToPrintAsRaster()) != null) {
            stringbuffer.append("v").append(attribute);
        }
        String string = stringbuffer.toString();
        return string.getBytes();
    }
}

