create table alert_type
(
    id      integer not null
        constraint idx_25582_primary
        primary key,
    name    text    not null,
    namerus text    not null
);


create table alertlog
(
    id                    serial
        constraint idx_25575_primary
        primary key,
    devid                 integer                  not null,
    hrdeviceindex         integer,
    prtalertindex         varchar(100)             not null,
    prtalertseveritylevel varchar(100)             not null,
    prtalerttraininglevel varchar(100)             not null,
    prtalertgroup         varchar(100)             not null,
    prtalertgroupindex    varchar(100)             not null,
    prtalertlocation      varchar(100)             not null,
    prtalertcode          varchar(100)             not null,
    prtalertdescription   text                     not null,
    prtalerttime          text                     not null,
    life                  bigint                   not null,
    alertend              timestamp with time zone,
    timeinsert            timestamp with time zone not null
);

create table coddesc
(
    "group"     varchar(40),
    idingroup   integer,
    name        varchar(45),
    description varchar(64)
);


create table counterlog
(
    id           serial
        constraint idx_25596_primary
        primary key,
    iddev        integer                                            not null,
    countervalue integer                                            not null,
    timesetvalue timestamp with time zone default CURRENT_TIMESTAMP not null
);


create table countries
(
    id   integer      not null,
    name varchar(100) not null
);


create table device_models
(
    id          bigserial
        constraint idx_25606_primary
        primary key,
    model_name  varchar(300) not null,
    vendor_id   bigint,
    extra_data  text,
    device_port varchar(10),
    protocol    varchar(10),
    date_format varchar(20),
    color       integer,
    format      varchar
);


create unique index model_id_name
    on device_models (model_name, vendor_id);


create table device_print_tech
(
    id      integer not null
        constraint idx_25613_primary
        primary key,
    name    text    not null,
    namerus text    not null
);


create table hibernate_sequence
(
    next_val bigint
);


create table hibernate_sequences
(
    sequence_name varchar(255) not null
        constraint idx_25622_primary
        primary key,
    next_val      bigint
);


create table hw_address_mask
(
    uuid     serial
        constraint idx_25627_primary
        primary key,
    vendor   varchar(30),
    phys_add varchar(17)
);

create table iana
(
    id     integer      not null,
    vendor varchar(256) not null
);

create unique index idx_25631_id
    on iana (id);

create table ips
(
    id        serial
        constraint idx_25636_primary
        primary key,
    ip_from   varchar(15) not null,
    ip_to     varchar(15) not null,
    name      varchar(50),
    is_active boolean default true
);


create table logs
(
    id      serial
        constraint idx_25642_primary
        primary key,
    devid   integer                                            not null,
    idevent integer                                            not null,
    time    timestamp with time zone default CURRENT_TIMESTAMP not null,
    id_src  integer,
    mac     varchar(12),
    text    varchar(1000)
);


create table nomenclature
(
    id                 bigserial
        constraint idx_25652_primary
        primary key,
    article            varchar(100),
    item_name          varchar(200) not null,
    bar_code           varchar(200),
    vendor             varchar(200),
    type               integer      not null,
    custom_description varchar(1000),
    add_date           timestamp with time zone default CURRENT_TIMESTAMP,
    modify_date        timestamp with time zone default CURRENT_TIMESTAMP,
    device_id          bigint
);

create table compatibility_link
(
    model_id bigint
        constraint model_fk
        references device_models,
    item_id  bigint
        constraint item_fk
        references nomenclature
);

create index idx_25591_item_fk
    on compatibility_link (item_id);

create unique index idx_25591_model_item
    on compatibility_link (model_id, item_id);


create index idx_25652_article_index
    on nomenclature (article);

create unique index idx_25652_unique_nomenclature
    on nomenclature (item_name, vendor, device_id);


create table params
(
    param_name    varchar(200) not null,
    param_type    varchar(200),
    param_value   varchar(1000),
    param_changed timestamp with time zone default CURRENT_TIMESTAMP,
    segment       varchar(200)             default 'PROD'::character varying,
    host_name     varchar(100)             default 'All'::character varying,
    description   varchar(500)             default 'description'::character varying
);

create unique index idx_25661_params_param_name_uindex
    on params (param_name, segment, host_name);

create table print_job
(
    id             bigserial
        constraint idx_25673_primary
        primary key,
    job_start_time timestamp with time zone,
    job_end_time   timestamp with time zone,
    device_id      text,
    job_id         varchar(200),
    order_id       varchar(200),
    file_name      varchar(250),
    job_state      varchar(50),
    job_type       varchar(50),
    job_owner      varchar(50),
    from_host      varchar(50),
    page_count     text,
    paper_size     varchar(10),
    job_src        varchar(200) default 'PRINTER'::character varying,
    pdf_path       varchar(300),
    dev_name       varchar(100)
);

create unique index idx_25673_job_id
    on print_job (job_id);

create table printer_connection_detail
(
    device_id   integer not null
        constraint idx_25681_primary
        primary key,
    device_port varchar(10),
    protocol    varchar(10),
    date_format varchar(20)
);

create table printers
(
    id                 serial
        constraint idx_25686_primary
        primary key,
    login              varchar(100),
    password           varchar(100),
    macaddress         varchar(12)  not null,
    vendor             varchar(100) not null,
    name               varchar(200) not null,
    sn                 varchar(64)  not null,
    ip                 bigint,
    "9100"             boolean      not null,
    "515"              boolean      not null,
    "631"              boolean      not null,
    snmp               boolean      not null,
    communityname      text,
    date_born          timestamp with time zone,
    date_last          timestamp with time zone,
    state              integer,
    deleted            integer,
    printtech          integer,
    format             varchar(11),
    color              integer,
    counter            integer,
    models             bigint  default '0'::bigint,
    job_collector_flag boolean default false,
    device_port        varchar(10),
    protocol           varchar(10),
    date_format        varchar(20),
    alias_printer      varchar(100),
    model_id           integer
);

create unique index idx_25686_macsn
    on printers (macaddress, sn);

create table properties
(
    description varchar(2000) not null,
    parameter   varchar(32)   not null
        constraint idx_25695_primary
        primary key,
    prop_value  varchar(32)
);

create table ps_queue
(
    id             serial
        constraint idx_25703_primary
        primary key,
    queue_name     varchar(200),
    counter        integer,
    is_direct      integer default 0,
    direct_printer integer default 0,
    is_active      integer default 1,
    queue_type     integer
);
create unique index idx_25703_ps_queue_queue_name_uindex
    on ps_queue (queue_name);

create table role
(
    id          bigint not null
        constraint idx_25710_primary
        primary key,
    description varchar(255),
    name        varchar(255),
    space       bigint
);

create unique index idx_25710_role_name
    on role (name);

create unique index idx_25710_role_name_unq
    on role (name);

create table session
(
    sessionid   varchar(34) not null
        constraint idx_25716_primary
        primary key,
    userid      integer,
    timecreated varchar(45),
    timelastuse varchar(45)
);

create table spring_session
(
    primary_id            char(36) not null
        constraint idx_25561_primary
        primary key,
    session_id            char(36) not null,
    creation_time         bigint   not null,
    last_access_time      bigint   not null,
    max_inactive_interval integer  not null,
    expiry_time           bigint   not null,
    principal_name        varchar(100)
);

create unique index idx_25561_spring_session_ix1
    on spring_session (session_id);

create index idx_25561_spring_session_ix2
    on spring_session (expiry_time);

create index idx_25561_spring_session_ix3
    on spring_session (principal_name);

create table spring_session_attributes
(
    session_id      char(36)     not null
        constraint spring_session_attributes_fk
        references spring_session (session_id)
        on delete cascade,
    attribute_name  varchar(200) not null,
    attribute_bytes bytea        not null,
    constraint idx_25564_primary
        primary key (session_id, attribute_name)
);

create index idx_25564_spring_session_attributes_ix1
    on spring_session_attributes (session_id);

create table stock_log
(
    id                  bigserial
        constraint idx_25729_primary
        primary key,
    item_id             bigint,
    request_date        timestamp with time zone default CURRENT_TIMESTAMP,
    request_description varchar(200),
    write_off_device    bigint
);

create index idx_25729_item_id
    on stock_log (item_id);

create table supplies_changes_log
(
    id          serial
        constraint idx_25756_primary
        primary key,
    dev_id      integer,
    type        integer,
    color       varchar(50),
    description varchar(100),
    sn          varchar(100),
    change_time timestamp with time zone
);

create table supplies_type
(
    id      integer not null
        constraint idx_25760_primary
        primary key,
    name    text    not null,
    namerus text    not null
);

create table supplieslog
(
    id              serial
        constraint idx_25746_primary
        primary key,
    devid           integer                                            not null,
    type            varchar(25),
    color           varchar(50),
    val             varchar(2000)                                      not null,
    description     varchar(500)                                       not null,
    snsupp          varchar(50)                                        not null,
    timeinsert      timestamp with time zone default CURRENT_TIMESTAMP not null,
    nomenclature_id bigint
);

create index idx_25746_sup_crit_check
    on supplieslog (devid, type, color);

create index idx_25746_supplieslog_devid_index
    on supplieslog (devid);

create table users
(
    id         integer not null
        constraint idx_25766_primary
        primary key,
    username   varchar(45),
    ful_name   varchar(45),
    "group"    integer,
    department integer,
    password   varchar(45)
);

create unique index idx_25766_username_unique
    on users (username);

create table usr
(
    id                     bigint  not null
        constraint idx_25772_primary
        primary key,
    active                 boolean not null,
    first_name             varchar(255),
    last_name              varchar(255),
    password               varchar(255),
    username               varchar(255),
    email                  varchar(255),
    firstname              varchar(255),
    lastname               varchar(255),
    print_permission       boolean,
    color_print_permission boolean,
    duplex_permission      boolean default true
);

create table storage
(
    id                 serial
        constraint idx_25736_primary
        primary key,
    storage_name       varchar(1000) not null,
    address            varchar(1000) not null,
    responsible_person bigint default '1'::bigint
        constraint responsible2userid
        references usr
);


create table stock
(
    id          bigserial
        constraint idx_25721_primary
        primary key,
    item_id     bigint                             not null
        constraint stock2nomenclature
        references nomenclature,
    item_count  integer                  default 0 not null,
    modify_date timestamp with time zone default CURRENT_TIMESTAMP,
    storage_id  integer                            not null
        constraint stock2storage
        references storage
);

create index idx_25721_stock2nomenclature
    on stock (item_id);

create index idx_25721_stock2storage
    on stock (storage_id);


create index idx_25736_responsible2userid
    on storage (responsible_person);


create table user_managerguid
(
    user_id     bigint       not null
        constraint usr_user_guid_fk
        references usr
        on delete cascade,
    managerguid varchar(100) not null,
    constraint idx_25570_primary
        primary key (user_id, managerguid)
);


create table users_roles
(
    user_id bigint not null
        constraint fk6h79md4xvnukidxrjob02u4xr
        references usr,
    roles   integer,
    role_id bigint not null
);


create index idx_25769_fk6h79md4xvnukidxrjob02u4xr
    on users_roles (user_id);

create index idx_25769_fkt4v0rrweyk393bdgt107vdx0x
    on users_roles (role_id);


create table price_stamp
(
    id         serial
        primary key,
    model      integer,
    color      integer,
    format     text,
    printer_id integer          default 0,
    price      double precision default 0
);


create unique index unic_model_id_color
    on price_stamp (model, color, printer_id);

create table user_group
(
    id          serial
        primary key,
    group_name  varchar(200)
        unique,
    description varchar(250)
);

create table users_group_relation
(
    user_id    integer not null
        references usr,
    group_id   integer not null
        references user_group,
    entry_date timestamp default CURRENT_TIMESTAMP,
    primary key (user_id, group_id)
);

