/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MibDirectoryCache {
    private static final Pattern NAME = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_]*");
    private File dir;
    private HashMap nameCache = null;
    private HashMap contentCache = null;

    public MibDirectoryCache(File dir) {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir;
    }

    public File findByName(String mibName) {
        if (this.nameCache == null) {
            this.initNameCache();
        }
        return (File)this.nameCache.get(mibName.toUpperCase());
    }

    private void initNameCache() {
        File[] files = this.dir.listFiles();
        this.nameCache = new HashMap();
        for (int i = 0; files != null && i < files.length; ++i) {
            String name = files[i].getName();
            Matcher m = NAME.matcher(name);
            if (!m.lookingAt() || !files[i].isFile()) continue;
            this.nameCache.put(m.group().toUpperCase(), files[i]);
        }
    }

    public File findByContent(String mibName) {
        if (this.contentCache == null) {
            this.initContentCache();
        }
        return (File)this.contentCache.get(mibName);
    }

    private void initContentCache() {
        File[] files = this.dir.listFiles();
        this.contentCache = new HashMap();
        for (int i = 0; i < files.length; ++i) {
            String name = this.readMibName(files[i]);
            if (name == null) continue;
            this.contentCache.put(name, files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readMibName(File file) {
        block20: {
            BufferedReader in = null;
            if (!file.canRead() || !file.isFile()) {
                return null;
            }
            try {
                String str;
                in = new BufferedReader(new FileReader(file));
                do {
                    if ((str = in.readLine()) != null) continue;
                    break block20;
                } while ((str = str.trim()).equals("") || str.startsWith("--"));
                Matcher m = NAME.matcher(str);
                String string = m.lookingAt() ? m.group() : null;
                return string;
            }
            catch (FileNotFoundException ignore) {
            }
            catch (IOException ignore) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return null;
    }
}

