/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.interunity.ep.dto.JobPriceDto;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.proc.Printer;

public class JobUtil {
    public static Integer findPageCount(String psFile) {
        Pattern pattern = Pattern.compile("%%Pages: \\d+");
        Matcher matcher = pattern.matcher(psFile);
        if (!matcher.find()) {
            return null;
        }
        String find = matcher.group();
        pattern = Pattern.compile("\\d+");
        matcher = pattern.matcher(find);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        return null;
    }

    public static String getPrintFormat(String psFile) {
        Pattern pattern = Pattern.compile("%%BeginFeature: \\*PageSize (.*?)(?:$|\\s|\\r|\\n)");
        Matcher matcher = pattern.matcher(psFile);
        if (matcher.find()) {
            return matcher.group().replace("%%BeginFeature: *PageSize ", "").trim();
        }
        return null;
    }

    public static Double getJobPrice(PrintJob job, List<JobPriceDto> price, Integer modelId, Integer color) {
        Double resultPrice = 0.0;
        for (JobPriceDto p : price) {
            if (job.getEyeprintPrinterId() == p.getPrinterId().longValue()) {
                if (modelId != p.getModel() || !job.getPrintFormat().contains(p.getFormat()) || p.getColor() < color) continue;
                resultPrice = p.getPrice();
                return resultPrice;
            }
            if (modelId != p.getModel() || !job.getPrintFormat().contains(p.getFormat()) || p.getColor() < color) continue;
            resultPrice = p.getPrice();
        }
        return resultPrice * (double)job.getPageCount().intValue();
    }

    public static Integer checkResultJobColor(Printer printer, String content) {
        return printer.getColor() > 1 && !content.contains("%%BeginFeature: *OKControl Gray") ? 4 : 1;
    }

    public static Boolean isJobContentColor(String content) {
        return !content.contains("%%BeginFeature: *OKControl Gray");
    }

    public static Boolean isJobDuplex(String jobContens) {
        return jobContens.contains("/Duplex true");
    }
}

