/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.servces;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.JobPriceDto;
import ru.interunity.ep.dto.JobSource;
import ru.interunity.ep.dto.JobStatus;
import ru.interunity.ep.dto.JobType;
import ru.interunity.ep.dto.PrintJob;

@Component
public class PrintJobWriter {
    private final JdbcTemplate template;

    public PrintJobWriter(JdbcTemplate template) {
        this.template = template;
    }

    public void update(ru.interunity.eyprint.ps.common.PrintJob job, JobStatus status) {
        this.template.update("update print_job set job_state=?, job_end_time=?, page_count=?, device_id=?, paper_size=? where id= ?", new Object[]{status.name(), LocalDateTime.now(), job.getPageCount(), job.getEyeprintPrinterId(), job.getPrintFormat(), job.getEyeprintJobId()});
    }

    public void writeNewJob(ru.interunity.eyprint.ps.common.PrintJob job) {
        String fileName = job.getControlFile().getControlFileCommands().getFileName();
        PrintJob ourJob = PrintJob.builder().jobOwner(job.getOwner()).jobType(JobType.PRINT).jobState(JobStatus.NEW).jobStartTime(LocalDateTime.now()).fromHost(job.getDataFile().getHostName()).fileName(fileName).source(JobSource.PRINT_SERVER).pdfPath(job.getPdfPath()).devName(job.getControlFile().getHostName()).build();
        BigInteger eyeprintId = this.addJob(ourJob);
        this.updatePdfPath(eyeprintId);
        job.setEyeprintJobId(eyeprintId);
    }

    private void updatePdfPath(BigInteger eyeprintId) {
        try {
            this.template.update("UPDATE print_job SET pdf_path = ? where id = ?", new Object[]{eyeprintId.longValue() + ".pdf", eyeprintId.longValue()});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BigInteger addJob(PrintJob printJob) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.template.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO print_job(job_start_time, job_id, file_name, job_state, job_type,job_owner, from_host, job_src, pdf_path, dev_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ", 1);
            ps.setTimestamp(1, Timestamp.valueOf(printJob.getJobStartTime()));
            ps.setString(2, printJob.getJobId());
            ps.setString(3, printJob.getFileName());
            ps.setString(4, printJob.getJobState().getStatusName());
            ps.setString(5, printJob.getJobType().getTypeName());
            ps.setString(6, printJob.getJobOwner());
            ps.setString(7, printJob.getFromHost());
            ps.setString(8, printJob.getSource().name());
            ps.setString(9, printJob.getPdfPath());
            ps.setString(10, printJob.getDevName());
            return ps;
        }, (KeyHolder)keyHolder);
        BigInteger key = keyHolder.getKeys().size() > 1 ? BigInteger.valueOf((Long)keyHolder.getKeys().get("id")) : BigInteger.valueOf((Long)keyHolder.getKey());
        return key;
    }

    public List<JobPriceDto> getPriceByModelOrPrinterId(Integer model, Long printerId) {
        ArrayList<JobPriceDto> price = new ArrayList<JobPriceDto>();
        this.template.query("SELECT * FROM am.price_stamp WHERE model = ? OR printer_id = ?", rs -> {
            while (rs.next()) {
                price.add(JobPriceDto.builder().id(Integer.valueOf(rs.getInt("id"))).model(Integer.valueOf(rs.getInt("model"))).color(Integer.valueOf(rs.getInt("color"))).format(rs.getString("format")).printerId(Long.valueOf(rs.getLong("printer_id"))).price(Double.valueOf(rs.getDouble("price"))).build());
            }
            return null;
        }, new Object[]{model, printerId});
        return price;
    }
}

