/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.proc;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.ep.dto.JobStatus;
import ru.interunity.ep.snmp.SnmpGetter;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.exception.ObjectNotFoundException;
import ru.interunity.eyprint.ps.proc.Printer;
import ru.interunity.eyprint.ps.proc.PrinterHolder;
import ru.interunity.eyprint.ps.servces.PrintJobWriter;
import ru.interunity.eyprint.ps.servces.PrintServerContext;
import ru.interunity.eyprint.ps.util.JobUtil;
import ru.interunity.eyprint.ps.util.PrintQueue;
import ru.interunity.eyprint.ps.util.QueuedPrintJob;
import ru.linologi.core.scp.srv.ParamLoadSrv;

public class PrintProcessor
implements Runnable {
    private final Logger logger;
    private boolean runned = true;
    private final PrintQueue printQueue;
    private final PrintJobWriter printJobWriter = (PrintJobWriter)PrintServerContext.getBean(PrintJobWriter.class);

    public PrintProcessor(PrintQueue printQueue) {
        this.printQueue = printQueue;
        this.logger = LoggerFactory.getLogger((String)(PrintProcessor.class + "-" + printQueue.getName()));
    }

    @Override
    public void run() {
        this.logger.info("Print processor start");
        ParamLoadSrv paramLoadSrv = (ParamLoadSrv)PrintServerContext.getBean(ParamLoadSrv.class);
        String mibPath = paramLoadSrv.getStringParam("eyeprint.mib.path");
        while (this.runned) {
            JobStatus status;
            QueuedPrintJob job = this.printQueue.getNextPrintJob();
            if (job == null) continue;
            Printer printer = PrinterHolder.getPrinterForQueue((PrintQueue)this.printQueue);
            Integer devCountBeforeJob = SnmpGetter.getDeviceCounter((String)printer.getIp(), (String)mibPath);
            try {
                printer.print(job.getPrintJob());
                status = JobStatus.DONE;
            }
            catch (IOException e) {
                status = JobStatus.ABORTED;
                this.logger.error("\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043d\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0435", (Throwable)e);
            }
            try {
                this.printQueue.remove(job.getJobId());
            }
            catch (ObjectNotFoundException e) {
                this.logger.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0447\u0430\u0442\u0438, \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430", (Throwable)e);
            }
            try {
                Thread.sleep(paramLoadSrv.getIntParam("eyeprint.ps.job.timeout").intValue());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            String psContetnt = new String(job.getPrintJob().getDataFile().getContents());
            Integer color = JobUtil.checkResultJobColor((Printer)printer, (String)psContetnt);
            job.getPrintJob().setEyeprintPrinterId(printer.getPrinterId());
            job.getPrintJob().setPrintFormat(JobUtil.getPrintFormat((String)psContetnt));
            job.getPrintJob().setPageCount(JobUtil.findPageCount((String)psContetnt));
            job.getPrintJob().setPrice(JobUtil.getJobPrice((PrintJob)job.getPrintJob(), (List)this.printJobWriter.getPriceByModelOrPrinterId(printer.getModel(), Long.valueOf(printer.getPrinterId())), (Integer)printer.getModel(), (Integer)color));
            this.printJobWriter.update(job.getPrintJob(), status);
        }
    }

    public void stop() {
        this.runned = false;
    }
}

