/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.lpd.LPDCommands;
import ru.interunity.eyprint.ps.util.NetUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class LpdSocketWorker
extends Thread {
    private final Socket connection;
    private static volatile int workerCounter = 0;
    static Logger log = LoggerFactory.getLogger(LpdSocketWorker.class);

    public LpdSocketWorker(Socket connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LPDCommands lpdCommands = new LPDCommands();
        NetUtil netUtil = new NetUtil();
        log.info("Connection opened.");
        log.info("Created a new PrintJob.");
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.connection.getInputStream();
            os = this.connection.getOutputStream();
            log.info("Got InputStream.");
            byte[] command = netUtil.readCommand(is);
            log.info("Command = {}", (Object)new String(command));
            lpdCommands.handleCommand(command, is, os);
        }
        catch (IOException e) {
            log.error("ERROR in try 2", (Throwable)e);
            log.debug(e.getMessage());
        }
        finally {
            if (null != this.connection) {
                log.debug("about to close connection.");
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    log.error("ERROR in try 2", (Throwable)e);
                }
            }
            if (null != is) {
                log.debug("about to close is.");
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("ERROR in try 2", (Throwable)e);
                }
            }
            if (null != os) {
                log.debug("about to close os.");
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error("Error: ", (Throwable)e);
                }
            }
        }
        LpdSocketWorker.downWorkerCounter();
    }

    public static synchronized int razeWorkerCounter() {
        log.info("Worker runned now " + ++workerCounter);
        return workerCounter;
    }

    public static synchronized void downWorkerCounter() {
        log.info("Worker runned now " + --workerCounter);
    }
}

