/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.widget.widgets;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.interunity.ep.web.widget.IWidget;
import ru.interunity.ep.web.widget.WidgetData;
import ru.interunity.ep.web.widget.WidgetItem;
import ru.interunity.ep.web.widget.WidgetTemplate;

public class DaysOfWeakCountWidget
implements IWidget {
    public WidgetData getData(WidgetTemplate template) {
        LinkedHashMap<String, WidgetItem> map = new LinkedHashMap<String, WidgetItem>();
        List dates = this.getDatesFromStartOfWeek();
        Map devId = template.getPrinterDao().getAllOnlineDevId();
        LinkedHashMap<Date, Integer> counts = new LinkedHashMap<Date, Integer>();
        for (Date date : dates) {
            Integer dayCount = 0;
            for (Map.Entry dev : devId.entrySet()) {
                dayCount = dayCount + template.getPrinterDao().getWeeklyCounter((Integer)dev.getKey(), date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay(), date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX));
            }
            counts.put(date, dayCount);
        }
        for (Map.Entry entry : counts.entrySet()) {
            map.put(((Date)entry.getKey()).toString(), WidgetItem.builder().itemColor("green").legendName(new SimpleDateFormat("yyyy-MM-dd").format((Date)entry.getKey())).itemValue((double)((Integer)entry.getValue()).intValue()).build());
        }
        return WidgetData.builder().name("\u0421\u0447\u0435\u0442\u0447\u0438\u043a \u043f\u043e \u0434\u043d\u044f\u043c \u043d\u0435\u0434\u0435\u043b\u0438").widgetItems(map).build();
    }

    private List<Date> getDatesFromStartOfWeek() {
        LinkedList<Date> dates = new LinkedList<Date>();
        LocalDate localDate = LocalDate.now().minusDays(6L);
        ZoneId defaultZoneId = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay(defaultZoneId).toInstant();
        Date date = Date.from(instant);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        while (calendar.getTime().before(new Date())) {
            dates.add(calendar.getTime());
            calendar.add(5, 1);
        }
        return dates;
    }
}

