/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.srv;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.interunity.ep.web.srv.BDConfig;
import ru.interunity.ep.web.srv.JdbcSqlInit;
import ru.reasy.snmp.beans.SnmpTarget;
import ru.reasy.snmp.mibs.MibException;
import ru.reasy.snmp.mibs.MibOperations;
import ru.reasy.snmp.snmp2.SnmpOID;
import ru.reasy.snmp.snmp2.SnmpVar;

public class DevInfoGet {
    private SnmpTarget target;
    private Map<String, String> devParam;
    private Map<String, String> alertGroup;
    private Map<String, String> doorState;
    private JdbcSqlInit jdbcSqlInit;

    public DevInfoGet(String idDev, JdbcSqlInit sin) {
        try {
            this.jdbcSqlInit = sin;
            this.devParam = sin.getParamForDevInfo(Integer.parseInt(idDev));
            this.target = new SnmpTarget();
            this.target.setTargetHost((String)this.devParam.get("ip"));
            this.target.setSnmpVersion(2);
            this.target.setCommunity("public");
            this.target.setTimeout(1);
            this.target.loadMibs(new BDConfig().getMibPath());
            this.alertGroup = new HashMap();
            this.doorState = new HashMap();
            this.alertGroup.put("12", "idDev");
            this.doorState.put("6", "\u0417\u0430\u043c\u043e\u043a \u0437\u0430\u043a\u0440\u044b\u0442");
            this.doorState.put("4", "\u041a\u0440\u044b\u0448\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public boolean checkDev() {
        String sn = "";
        this.target.setObjectID("prtGeneralSerialNumber");
        SnmpVar res = this.target.snmpGetNextVariable();
        if (res != null) {
            sn = res.getVarObject().toString();
            if (sn.length() < 3) {
                sn = "";
            }
        } else {
            res = this.target.snmpGetNextVariable();
            if (res != null && (sn = res.getVarObject().toString()).length() < 3) {
                sn = "";
            }
        }
        String mac = "";
        this.target.setObjectID("ifPhysAddress");
        res = this.target.snmpGetNextVariable();
        if (res != null) {
            mac = this.target.snmpGet();
            mac = mac.length() < 12 ? "" : mac.replace(" ", "");
        } else {
            res = this.target.snmpGetNextVariable();
            if (res != null) {
                mac = this.target.snmpGet();
                if ((mac = mac.replace(" ", "")).length() < 12) {
                    mac = "";
                }
            }
        }
        System.out.println(mac + "==" + (String)this.devParam.get("mac"));
        System.out.println(sn + "==" + (String)this.devParam.get("sn"));
        return mac.equals(this.devParam.get("mac")) && sn.equals(this.devParam.get("sn"));
    }

    public String mainInfo() throws MibException, IOException {
        try {
            String mainMib = "sysDescr";
            this.target.setObjectID(mainMib);
            return this.target.snmpGetNext();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public String getAllSupplies() throws MibException, IOException, ClassNotFoundException, SQLException {
        int minLevel = this.jdbcSqlInit.getParam("alertSupp");
        Map refAl = this.jdbcSqlInit.getCodeDescr("PrtMarkerSuppliesType");
        String mainMib = "prtMarkerSuppliesMarkerIndex";
        this.target.setObjectID(mainMib);
        MibOperations mibOps = this.target.getMibOperations();
        SnmpOID rootoid = mibOps.getSnmpOID(mainMib);
        Date dt = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
        String dateGet = sdfDate.format(dt) + "&nbsp;" + sdfTime.format(dt);
        boolean stOid = false;
        if (this.target.snmpGetNextVariable() != null) {
            stOid = true;
        }
        Object forRet = "<div><table class='currentSupp'><thead><b>\u0420\u0430\u0441\u0445\u043e\u0434\u043d\u044b\u0435 \u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u043d\u044b\u0435 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044b</b></thead>";
        while (true) {
            if (!(SnmpTarget.isInSubTree((SnmpOID)rootoid, (SnmpOID)this.target.getSnmpOIDList()[0]) & stOid)) break;
            Object rowForRet = "";
            String indexOid = "";
            String thisOid = this.target.getObjectID();
            indexOid = thisOid.split(mainMib)[1];
            this.target.setObjectID("prtMarkerSuppliesDescription" + indexOid);
            SnmpVar desc = this.target.snmpGetVariable();
            if (desc == null) continue;
            String sn = this.getSN("" + desc.toValue());
            this.target.setObjectID("prtMarkerSuppliesType" + indexOid);
            SnmpVar typeSupp = this.target.snmpGetVariable();
            if (typeSupp == null) continue;
            this.target.setObjectID("prtMarkerSuppliesColorantIndex" + indexOid);
            SnmpVar colorIndexSupp = this.target.snmpGetVariable();
            if (colorIndexSupp == null) continue;
            Object colorSupp1 = "";
            if ((Integer)colorIndexSupp.toValue() != 0) {
                this.target.setObjectID("prtMarkerColorantValue.1." + colorIndexSupp.toValue());
                SnmpVar colorSupp = this.target.snmpGetVariable();
                if (colorSupp == null) {
                    this.target.setObjectID("prtMarkerColorantValue." + colorIndexSupp.toValue() + "." + colorIndexSupp.toValue());
                    colorSupp = this.target.snmpGetVariable();
                    if (colorSupp == null) continue;
                }
                colorSupp1 = "" + colorSupp;
            }
            rowForRet = (String)rowForRet + "<td class='type'>" + refAl.get(typeSupp.toValue().toString()) + "</td>";
            rowForRet = (String)rowForRet + "<td class='color'>" + (String)colorSupp1 + "</td>";
            double suppLev = this.getSuppliesLevel(indexOid);
            if (suppLev == -1000.0) continue;
            rowForRet = (String)rowForRet + "<td class='val'>" + suppLev + "%</td>";
            rowForRet = (String)rowForRet + "<td class='desc' style='display: none;'>" + (String)desc.getVarObject() + "</td>";
            rowForRet = (String)rowForRet + "<td class='sn'>" + sn + "</td>";
            this.target.setObjectID(thisOid);
            this.target.snmpGetNextVariable();
            rowForRet = suppLev < (double)minLevel ? "<tr class='minLev'><td class='date_time' style='display: none;'>" + dateGet + "</td>" + (String)rowForRet + "</tr>" : "<tr><td class='date_time' style='display: none;'>" + dateGet + "</td>" + (String)rowForRet + "</tr>";
            forRet = (String)forRet + (String)rowForRet;
        }
        return (String)forRet + "</table></div>";
    }

    private String getSN(String disc) {
        Pattern p1;
        Matcher m1;
        disc = disc.toUpperCase();
        Pattern p = Pattern.compile("([A-Z0-9]{6,24})$");
        Matcher m = p.matcher(disc);
        if (m.find() && (m1 = (p1 = Pattern.compile("[0-9]+")).matcher(m.group(1))).find()) {
            return m.group(1);
        }
        return "";
    }

    private double getSuppliesLevel(String ind) throws MibException, IOException {
        double levMax;
        double lev;
        try {
            this.target.setObjectID("prtMarkerSuppliesLevel" + ind);
            SnmpVar levelVal = this.target.snmpGetVariable();
            if (!(levelVal != null & levelVal.getTypeString().equals("INTEGER"))) {
                return -1000.0;
            }
            lev = Integer.parseInt(levelVal.toString());
            this.target.setObjectID("prtMarkerSuppliesMaxCapacity" + ind);
            SnmpVar levelMax = this.target.snmpGetVariable();
            if (!levelVal.getTypeString().equals("INTEGER")) {
                return -1000.0;
            }
            levMax = Integer.parseInt(levelMax.toString());
        }
        catch (Exception e) {
            return -1000.0;
        }
        double stat = lev / levMax;
        int st = (int)Math.round(stat *= 100.0);
        stat = st;
        return stat;
    }

    public String getAllStates() throws UnsupportedEncodingException {
        String mainMib = "prtCoverDescription";
        this.target.setObjectID(mainMib);
        MibOperations mibOps = this.target.getMibOperations();
        SnmpOID rootoid = mibOps.getSnmpOID(mainMib);
        boolean stOid = false;
        if (this.target.snmpGetNextVariable() != null) {
            stOid = true;
        }
        Date dt = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
        String dateGet = sdfDate.format(dt) + "&nbsp;" + sdfTime.format(dt);
        Object forRet = "";
        while (true) {
            if (!(SnmpTarget.isInSubTree((SnmpOID)rootoid, (SnmpOID)this.target.getSnmpOIDList()[0]) & stOid)) break;
            String thisOid = this.target.getObjectID();
            String indexOid = thisOid.split(mainMib)[1];
            this.target.setObjectID(thisOid);
            SnmpVar unit = this.target.snmpGetVariable();
            String unitName = "";
            if (unit == null) continue;
            unitName = new String(unit.toBytes(), "UTF-8");
            forRet = (String)forRet + "<tr><td class='date_time' style='display: none;'>" + dateGet + "</td><td>" + unitName + "</td>";
            this.target.setObjectID("prtCoverStatus" + indexOid);
            SnmpVar state = this.target.snmpGetVariable();
            forRet = (String)forRet + "<td>" + (String)this.doorState.get(state.toValue().toString()) + "</td></tr>";
            this.target.setObjectID(thisOid);
            this.target.snmpGetNextVariable();
        }
        return "<div><table class='currentKeyLock'><thead><b>\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0434\u0430\u0442\u0447\u0438\u043a\u043e\u0432</b></thead>" + (String)forRet + "</table></div>";
    }

    public String getAllAlerts() throws SQLException, ClassNotFoundException, UnsupportedEncodingException {
        String mainMib = "prtAlertDescription";
        Map alertCodeRef = this.jdbcSqlInit.getCodeDescr("PrtAlertCode");
        Map alertGroupRef = this.jdbcSqlInit.getCodeDescr("prtAlertGroup");
        Map alertLevelRef = this.jdbcSqlInit.getCodeDescr("prtAlertTrainingLevel");
        this.target.setObjectID(mainMib);
        MibOperations mibOps = this.target.getMibOperations();
        SnmpOID rootoid = mibOps.getSnmpOID(mainMib);
        boolean stOid = false;
        if (this.target.snmpGetNextVariable() != null) {
            stOid = true;
        }
        Object line = "";
        Object forRet = "";
        while (true) {
            if (!(SnmpTarget.isInSubTree((SnmpOID)rootoid, (SnmpOID)this.target.getSnmpOIDList()[0]) & stOid)) break;
            String thisOid = this.target.getObjectID();
            String indexOid = thisOid.split(mainMib)[1];
            this.target.setObjectID(thisOid);
            String alertDescr = "";
            SnmpVar descr = this.target.snmpGetVariable();
            if (descr == null) continue;
            alertDescr = new String(descr.toBytes(), "UTF-8");
            line = "<td>" + alertDescr + "</td>";
            this.target.setObjectID("prtAlertCode" + indexOid);
            SnmpVar code = this.target.snmpGetVariable();
            if (code == null) continue;
            line = (String)line + "<td>" + (String)alertCodeRef.get(code.toValue().toString()) + "</td>";
            this.target.setObjectID("prtAlertGroup" + indexOid);
            SnmpVar gruop = this.target.snmpGetVariable();
            if (gruop == null) continue;
            line = (String)line + "<td>" + (String)alertGroupRef.get(gruop.toValue().toString()) + "</td>";
            this.target.setObjectID("prtAlertTrainingLevel" + indexOid);
            SnmpVar alertLevel = this.target.snmpGetVariable();
            if (alertLevel == null) continue;
            line = (String)line + "<td style='display: none;'>" + (String)alertLevelRef.get(alertLevel.toValue().toString()) + "</td>";
            this.target.setObjectID("prtAlertTime" + indexOid);
            SnmpVar time = this.target.snmpGetVariable();
            if (time == null) continue;
            this.target.setObjectID("sysUpTime");
            SnmpVar upTime = this.target.snmpGetNextVariable();
            if (upTime == null) continue;
            Date dts = new Date();
            long timeStamp = dts.getTime() / 1000L;
            int upTimeVal = Integer.parseInt(upTime.toValue().toString());
            long timeStart = timeStamp - (long)(upTimeVal / 100);
            long timeAlert = timeStart + (Long)time.toValue() / 100L;
            Date date = new Date(timeAlert * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String formattedDate = sdf.format(date);
            forRet = (String)forRet + "<tr><td class='date_time'>" + formattedDate + "</td><td>" + (String)line + "</td></tr>";
            this.target.setObjectID(thisOid);
            this.target.snmpGetNextVariable();
        }
        return "<div><table class='currentAlert'><thead><b>\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f</b></thead>" + (String)forRet + "</table></div>";
    }
}

