/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.service;

import javax.transaction.Transactional;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.StockDto;
import ru.interunity.ep.web.dao.StockDao;
import ru.interunity.ep.web.dao.StockLogDao;
import ru.interunity.ep.web.dto.ChangeType;
import ru.interunity.ep.web.dto.StockChangeRq;
import ru.interunity.ep.web.dto.StockChangeType;

@Component
public class StockMovingSrv {
    private final StockDao stockDao;
    private final StockLogDao stockLogDao;

    @Transactional
    public void changeStock(StockChangeRq request) throws Exception {
        try {
            if (request.getType() == StockChangeType.DECREASE) {
                this.stockDao.decriesStockItem((long)request.getStockItemId(), request.getCount());
                this.stockLogDao.addNewLogItem(StockDto.builder().id((long)request.getStockItemId()).itemId((long)request.getStockItemId()).itemCount(Long.valueOf(request.getCount())).writeOffDevice(Long.valueOf(request.getDeviceId())).requestDescription(request.getComment()).modifyDate(request.getMovingDateTime()).build(), ChangeType.MANUAL);
            }
        }
        catch (Exception e) {
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0432 \u0411\u0414");
        }
    }

    public StockMovingSrv(StockDao stockDao, StockLogDao stockLogDao) {
        this.stockDao = stockDao;
        this.stockLogDao = stockLogDao;
    }
}

