/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.SuppliesDTO;

@Component
public class SuppliesChangesLogDao {
    private final JdbcTemplate template;

    public SuppliesChangesLogDao(JdbcTemplate template) {
        this.template = template;
    }

    public List<SuppliesDTO> getChangeLogByDate(LocalDateTime startTime, LocalDateTime endTime) {
        return (List)this.template.query("SELECT * FROM supplies_changes_log WHERE change_time > ? AND change_time < ?", rs -> {
            ArrayList<SuppliesDTO> changes = new ArrayList<SuppliesDTO>();
            while (rs.next()) {
                changes.add(SuppliesDTO.builder().id(Long.valueOf(rs.getLong("id"))).devId(Long.valueOf(rs.getLong("dev_id"))).type(String.valueOf(rs.getInt("type"))).color(rs.getString("color")).description(rs.getString("description")).sn(rs.getString("sn")).timeInsert((Date)rs.getTimestamp("change_time")).build());
            }
            return changes;
        }, new Object[]{startTime, endTime});
    }

    public List<SuppliesDTO> getChangeLogByDateAndId(Integer id) {
        return (List)this.template.query("SELECT * FROM supplies_changes_log WHERE dev_id = ?", rs -> {
            ArrayList<SuppliesDTO> changes = new ArrayList<SuppliesDTO>();
            while (rs.next()) {
                changes.add(SuppliesDTO.builder().id(Long.valueOf(rs.getLong("id"))).devId(Long.valueOf(rs.getLong("dev_id"))).type(String.valueOf(rs.getInt("type"))).color(rs.getString("color")).description(rs.getString("description")).sn(rs.getString("sn")).timeInsert((Date)rs.getTimestamp("change_time")).build());
            }
            return changes;
        }, new Object[]{id});
    }

    public void addNewChangeLogItem(SuppliesDTO supplies) {
        this.template.update("INSERT INTO supplies_changes_log(dev_id, type, color, description, sn, change_time) VALUES (?, ?, ?, ?, ?, ?)", new Object[]{supplies.getDevId(), supplies.getType(), supplies.getColor(), supplies.getDescription(), supplies.getSn(), supplies.getTimeInsert()});
    }

    public void updateChangeLogItemById(SuppliesDTO supplies) {
        this.template.update("UPDATE supplies_changes_log SET dev_id =?, type=?, color=?, description=?, sn=?, change_time=? WHERE id = ?", new Object[]{supplies.getDevId(), supplies.getType(), supplies.getColor(), supplies.getDescription(), supplies.getSn(), supplies.getTimeInsert(), supplies.getId()});
    }

    public void deleteById(Integer id) {
        this.template.update("DELETE FROM supplies_changes_log WHERE id = ?", new Object[]{id});
    }
}

