/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.StockDto;

@Component
public class StockDao {
    private final JdbcTemplate template;

    public StockDao(JdbcTemplate template) {
        this.template = template;
    }

    public void addNewStockItem(StockDto stock) {
        this.template.update("INSERT INTO stock(item_id, item_count, storage_id) VALUES (?, ?, ?)", new Object[]{stock.getItemId(), stock.getItemCount(), stock.getStorageId()});
    }

    public StockDto getStockItem(Integer itemId) {
        return (StockDto)this.template.query("SELECT * FROM stock WHERE item_id = ?", rs -> {
            StockDto stock = null;
            if (rs.next()) {
                stock = StockDto.builder().id((long)rs.getInt("id")).itemId((long)rs.getInt("item_id")).itemCount(Long.valueOf(rs.getLong("item_count"))).modifyDate(rs.getTimestamp("modify_date").toLocalDateTime()).storageId(Integer.valueOf(rs.getInt("storage_id"))).build();
            }
            return stock;
        }, new Object[]{itemId});
    }

    public void updateItem(StockDto stock) {
        this.template.update("UPDATE stock SET item_count = ?, modify_date = now(), storage_id = ? WHERE item_id = ?", new Object[]{stock.getItemCount(), stock.getStorageId(), stock.getItemId()});
    }

    public List<StockDto> getStockItems() {
        return this.template.query("SELECT stock.id as id, stock.item_id, n.item_name, stock.item_count, stock.storage_id,  n.custom_description, st.storage_name, n.vendor, n.bar_code  FROM stock join nomenclature n on n.id = stock.item_id  join storage st on stock.storage_id = st.id", (rs, num) -> StockDto.builder().id((long)rs.getInt("id")).itemId((long)rs.getInt("item_id")).itemCount(Long.valueOf(rs.getLong("item_count"))).storageId(Integer.valueOf(rs.getInt("storage_id"))).storageName(rs.getString("storage_name")).vendorName(rs.getString("vendor")).article(rs.getString("bar_code")).requestDescription(rs.getString("custom_description")).build());
    }

    public void decriesStockItem(long itemId, long count) {
        this.template.update("update stock set item_count = item_count - ? where id = ?", new Object[]{count, itemId});
    }
}

