/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.CounterReportItem;
import ru.interunity.ep.dto.Device;
import ru.interunity.ep.utils.IpUtil;

@Component
public class ReportDao {
    private final JdbcTemplate jdbcTemplate;

    public ReportDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<CounterReportItem> getCounterReport(LocalDateTime dateStart, LocalDateTime dateEnd) {
        ArrayList<CounterReportItem> counterReportItems = new ArrayList<CounterReportItem>();
        this.jdbcTemplate.query("SELECT printers.id as devId, printers.name as devName, printers.ip as devIp, zap1.re, zap1.st, zap1.fn FROM printers INNER JOIN (SELECT idDev, MAX(counterValue) as fn, MIN(counterValue) as st, (MAX(counterValue)-MIN(counterValue)) as re FROM counterLog WHERE timeSetValue>= ? and timeSetValue<= ? GROUP BY idDev ) zap1 ON zap1.idDEv=printers.id ORDER BY re DESC", rs1 -> {
            while (rs1.next()) {
                Device device = new Device();
                device.setId(rs1.getLong("devId"));
                device.setName(rs1.getString("devName"));
                device.setIp(IpUtil.long2ip((long)rs1.getLong("devIp")));
                CounterReportItem counterReportItem = CounterReportItem.builder().device(device).begin(Long.valueOf(rs1.getLong("st"))).end(Long.valueOf(rs1.getLong("fn"))).different(Long.valueOf(rs1.getLong("re"))).build();
                counterReportItem.setDevice(device);
                counterReportItems.add(counterReportItem);
            }
            return null;
        }, new Object[]{dateStart, dateEnd});
        return counterReportItems;
    }
}

