/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.PrintPermissionDto;
import ru.interunity.ep.web.dao.UserPrintPermissionDao;

@RestController
@RequestMapping(value={"/api/v2/permission"})
public class UserPrintPermissionController {
    private final UserPrintPermissionDao userPrintPermissionDao;

    public UserPrintPermissionController(UserPrintPermissionDao userPrintPermissionDao) {
        this.userPrintPermissionDao = userPrintPermissionDao;
    }

    @GetMapping(value={"/get-all-permission"})
    public ResponseEntity<List<PrintPermissionDto>> getAllGroups() {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.userPrintPermissionDao.getAllUserPermission());
    }

    @PostMapping(value={"/update-permission"})
    public ResponseEntity<String> updateAllPermission(@RequestBody PrintPermissionDto permission) {
        try {
            return this.userPrintPermissionDao.updatePermission(permission) != 0 ? ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"Permission updated") : ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("User with id " + permission.getId() + " not found"));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/update-permission-by-name"})
    public ResponseEntity<String> updatePrintPermission(@RequestBody PrintPermissionDto permission) {
        try {
            return this.userPrintPermissionDao.updatePermissionByName(permission) != 0 ? ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"Permission updated") : ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("User with id " + permission.getId() + " not found"));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
    }
}

