/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.StockDto;
import ru.interunity.ep.web.dao.StockDao;
import ru.interunity.ep.web.dto.StockChangeRq;
import ru.interunity.ep.web.dto.StockChangeRs;
import ru.interunity.ep.web.service.StockMovingSrv;

@RestController
@RequestMapping(value={"/api/v2/stock"})
public class StockController {
    private final StockDao stockDao;
    private final StockMovingSrv stockMovingSrv;

    @PostMapping(value={"/add"})
    public void AddStock(@RequestBody StockDto stock) {
        this.stockDao.addNewStockItem(stock);
    }

    @GetMapping(value={"/get"})
    public StockDto getStockByItemId(@RequestParam Integer itemId) {
        return this.stockDao.getStockItem(itemId);
    }

    @PatchMapping(value={"/update"})
    public void updateStock(@RequestBody StockDto stock) {
        this.stockDao.updateItem(stock);
    }

    @GetMapping(value={"/list"})
    public List<StockDto> getStocks() {
        return this.stockDao.getStockItems().stream().filter(one -> one.getItemCount() > 0L).collect(Collectors.toList());
    }

    @PostMapping(value={"/move"})
    public ResponseEntity<StockChangeRs> moveStock(@RequestBody StockChangeRq changeRq) {
        try {
            this.stockMovingSrv.changeStock(changeRq);
            return ResponseEntity.ok((Object)StockChangeRs.success());
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)StockChangeRs.error((String)e.getMessage()));
        }
    }

    public StockController(StockDao stockDao, StockMovingSrv stockMovingSrv) {
        this.stockDao = stockDao;
        this.stockMovingSrv = stockMovingSrv;
    }
}

