/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.CounterReportItem;
import ru.interunity.ep.web.dto.ReportExcelRs;
import ru.interunity.ep.web.dto.ReportRs;
import ru.interunity.ep.web.dto.ReportType;
import ru.interunity.ep.web.dto.UserReportItem;
import ru.interunity.ep.web.service.ReportService;
import ru.interunity.ep.web.srv.ExcelReportProcessor;
import ru.linologi.core.scp.srv.ParamLoadSrv;

@RestController
@RequestMapping(value={"/api/v2/reports"})
public class ReportController {
    private final ReportService reportService;
    private final ExcelReportProcessor excelReportProcessor;
    private final ParamLoadSrv paramLoadSrv;
    private final Logger logger = LoggerFactory.getLogger(ReportController.class);

    @GetMapping(value={"/full-report"})
    public List<CounterReportItem> getFullReport(@RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime dateStart, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime dateEnd) {
        return this.reportService.getFullReport(dateStart, dateEnd);
    }

    @GetMapping(value={"/get-types"})
    public List<ReportType> getReport() {
        return List.of(ReportType.builder().reportType("USER_REPORT").description("\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c").build(), ReportType.builder().reportType("DEVICE_REPORT").description("\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430\u043c").build(), ReportType.builder().reportType("JOB_REPORT").description("\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f\u043c").build(), ReportType.builder().reportType("COUNTER_REPORT").description("\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430\u043c").build());
    }

    @GetMapping(value={"/report-excel"})
    public ReportExcelRs getExcelReportRs(@RequestParam String type, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime start, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime end) {
        ReportRs report = this.getReportRs(type, start, end);
        ReportExcelRs fileRs = this.excelReportProcessor.process(report);
        fileRs.setUrl("/api/v2/reports/file/" + fileRs.getFileName());
        return fileRs;
    }

    @GetMapping(value={"/report"})
    public ReportRs getReportRs(@RequestParam String type, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime start, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime end) {
        switch (type) {
            case "USER_REPORT": {
                return this.getDefaultReport();
            }
            case "DEVICE_REPORT": {
                return this.reportService.getDeviceReport(start, end);
            }
            case "JOB_REPORT": {
                return this.reportService.getJob(start, end);
            }
            case "COUNTER_REPORT": {
                return this.reportService.getCounter();
            }
        }
        return this.getDefaultReport();
    }

    @GetMapping(value={"/file/{fileName}"})
    public ResponseEntity<Resource> getSavedJobFile(@PathVariable String fileName) throws IOException {
        FileSystemResource file = new FileSystemResource(this.paramLoadSrv.getStringParam("eyeprint.web.report.store", "/opt/eyeprint/storage/pdf/") + fileName);
        if (!file.exists()) {
            this.logger.error("File not found!");
            throw new FileNotFoundException("File not found!");
        }
        String contentType = null;
        try {
            contentType = URLConnection.guessContentTypeFromName(file.getFile().getName());
        }
        catch (Exception e) {
            this.logger.error("Content type is not defined!");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
    }

    private ReportRs getDefaultReport() {
        return ReportRs.builder().headers(List.of(ReportRs.ReportHeader.builder().columnName("\u0414\u0430\u0442\u0430").columnType("string").fieldName("eventDateTime").build(), ReportRs.ReportHeader.builder().columnName("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c").columnType("string").fieldName("user").build(), ReportRs.ReportHeader.builder().columnName("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0442\u043f\u0435\u0447\u0430\u0442\u043a\u043e\u0432").columnType("integer").fieldName("counter").build())).items(List.of(UserReportItem.builder().counter(Integer.valueOf(100)).eventDateTime(LocalDateTime.now().toString()).user("korgan").build(), UserReportItem.builder().counter(Integer.valueOf(100)).eventDateTime(LocalDateTime.now().toString()).user("a.").build(), UserReportItem.builder().counter(Integer.valueOf(100)).eventDateTime(LocalDateTime.now().toString()).user("admin").build(), UserReportItem.builder().counter(Integer.valueOf(100)).eventDateTime(LocalDateTime.now().toString()).user("admin").build(), UserReportItem.builder().counter(Integer.valueOf(100)).eventDateTime(LocalDateTime.now().toString()).user("admin").build(), UserReportItem.builder().counter(Integer.valueOf(100)).eventDateTime(LocalDateTime.now().toString()).user("admin").build(), UserReportItem.builder().counter(Integer.valueOf(100)).eventDateTime(LocalDateTime.now().toString()).user("secretar").build(), UserReportItem.builder().counter(Integer.valueOf(100)).eventDateTime(LocalDateTime.now().toString()).user("user").build())).build();
    }

    public ReportController(ReportService reportService, ExcelReportProcessor excelReportProcessor, ParamLoadSrv paramLoadSrv) {
        this.reportService = reportService;
        this.excelReportProcessor = excelReportProcessor;
        this.paramLoadSrv = paramLoadSrv;
    }
}

