/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.Device;
import ru.interunity.ep.web.dto.SetAliasesRq;
import ru.interunity.ep.web.dto.SetAliasesRs;
import ru.interunity.ep.web.service.PrinterServiceImpl;

@RestController
@RequestMapping(value={"/api/v2/printers"})
public class PrinterController {
    private final PrinterServiceImpl printerService;

    @Autowired
    public PrinterController(PrinterServiceImpl printerService) {
        this.printerService = printerService;
    }

    @GetMapping(value={"/get"})
    public List<Device> getAllPrinters() {
        return this.printerService.getAllPrinters();
    }

    @GetMapping(value={"/get-with-sup"})
    public List<Device> getAllPrintersWithSuppliesLevel() {
        return this.printerService.getPrintersWithSuppliesLevel();
    }

    @PostMapping(value={"/set-aliases"})
    public SetAliasesRs setAliases(@RequestBody SetAliasesRq setAliasesRq) {
        try {
            this.printerService.setAliases(setAliasesRq.getDeviceId(), setAliasesRq.getAlias());
            return SetAliasesRs.builder().success(Boolean.valueOf(true)).build();
        }
        catch (Exception e) {
            return SetAliasesRs.builder().success(Boolean.valueOf(false)).build();
        }
    }
}

