/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.JobPriceDto;
import ru.interunity.ep.web.service.JobPriceService;

@RestController
@RequestMapping(value={"/api/v2/price"})
public class JobPriceController {
    private final JobPriceService jobPriceService;

    public JobPriceController(JobPriceService jobPriceService) {
        this.jobPriceService = jobPriceService;
    }

    @GetMapping(value={"/all"})
    public List<JobPriceDto> getAll() {
        return this.jobPriceService.getAllPrice();
    }

    @PostMapping(value={"/delete-by-id/{id}"})
    public ResponseEntity<String> deleteById(@PathVariable Integer id) {
        return this.jobPriceService.deleteById(id) > 0 ? ResponseEntity.ok().body((Object)("Delete price with id " + id)) : ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("Not found id " + id + " or incorrect parameter"));
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<String> addNewPrice(@RequestBody JobPriceDto price) {
        return this.jobPriceService.addNewPrice(price) ? ResponseEntity.ok().body((Object)"Add new price success") : ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"Not add new price");
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<String> updatePrice(@RequestBody JobPriceDto price) {
        return this.jobPriceService.updatePrice(price) != false ? ResponseEntity.ok().body((Object)("Update price with id: " + price.getId())) : ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Not update price with id: " + price.getId()));
    }
}

