/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.EpNetwork;
import ru.interunity.ep.web.dao.IPSDao;

@RestController
@RequestMapping(value={"/api/v2/ips"})
public class IPSController {
    private final IPSDao ipsDao;

    public IPSController(IPSDao ipsDao) {
        this.ipsDao = ipsDao;
    }

    @GetMapping(value={"/get-by-id"})
    public EpNetwork getIPSbyId(@RequestParam Integer id) {
        return this.ipsDao.getIPSbyId(id.intValue());
    }

    @GetMapping(value={"/get-all"})
    public List<EpNetwork> getAllIPS() {
        return this.ipsDao.getAllIPS();
    }

    @PostMapping(value={"/add"})
    public HttpStatus addIPS(@RequestBody EpNetwork network) {
        this.ipsDao.addIps(network);
        return HttpStatus.OK;
    }

    @PostMapping(value={"/update"})
    public HttpStatus updateIPS(@RequestBody EpNetwork network) {
        this.ipsDao.updateIps(network);
        return HttpStatus.OK;
    }

    @DeleteMapping(value={"/delete"})
    public HttpStatus deleteIPS(@RequestParam Integer id) {
        this.ipsDao.deleteIps(id.intValue());
        return HttpStatus.OK;
    }
}

