/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import ru.interunity.ep.dao.PrinterDao;
import ru.interunity.ep.printjobDao.dao.PrintJobDao;
import ru.interunity.ep.web.controller.DashboardController;

/*
 * Exception performing whole class analysis ignored.
 */
public class DashboardController {
    private final PrinterDao printerDao;
    private final PrintJobDao printJobDao;
    private static final Logger log = LoggerFactory.getLogger(DashboardController.class);
    private static final String DEVICE_ONLINE = "DEVICE_ONLINE";
    private static final String DEVICE_STATE = "DEVICE_STATE";

    public DashboardController(PrinterDao printerDao, PrintJobDao printJobDao) {
        this.printerDao = printerDao;
        this.printJobDao = printJobDao;
    }

    @GetMapping(value={"/data/{widgetId}"})
    public WidgetData getWidgetData(@PathVariable String widgetId) {
        ArrayList res;
        HashMap<String, WidgetItem> map = new HashMap<String, WidgetItem>();
        if ("DEVICE_ONLINE".equals(widgetId) || "DEVICE_STATE".equals(widgetId)) {
            AtomicInteger online = new AtomicInteger(0);
            AtomicInteger offLine = new AtomicInteger(0);
            this.printerDao.getDevList().forEach(dev -> {
                if (dev.getState() == 1) {
                    online.getAndIncrement();
                } else {
                    offLine.getAndIncrement();
                }
            });
            map.put("\u041e\u043d\u043b\u0430\u0439\u043d", WidgetItem.builder().itemValue(online.doubleValue()).legendName("\u041e\u043d\u043b\u0430\u0439\u043d").itemColor("green").build());
            map.put("\u041e\u0444\u043b\u0430\u0439\u043d", WidgetItem.builder().itemValue(offLine.doubleValue()).legendName("\u041e\u0444\u043b\u0430\u0439\u043d").itemColor("rad").build());
            return WidgetData.builder().name("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432").id(widgetId).widgetItems(map).build();
        }
        log.info("getWidgetData > {}", (Object)widgetId);
        try {
            res = this.printJobDao.getReportByDate(LocalDateTime.now().minusDays(30L), LocalDateTime.now().plusDays(1L));
        }
        catch (Exception ex) {
            log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u0432\u0438\u0434\u0436\u0435\u0442\u0443", (Throwable)ex);
            res = new ArrayList();
        }
        map.put("\u041e\u0442\u043f\u0435\u0447\u0430\u0442\u0430\u043d\u043e", WidgetItem.builder().itemColor("green").legendName("\u041e\u0442\u043f\u0435\u0447\u0430\u0442\u0430\u043d\u043e").itemValue((double)res.size()).build());
        return WidgetData.builder().name("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432").id(widgetId).widgetItems(map).build();
    }

    @GetMapping(value={"/data/{widgetId}/{startDate}/{endDate}"})
    public WidgetData getWidgetDataWithDate(@PathVariable String widgetId, @PathVariable @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime startDate, @PathVariable @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime endDate) {
        log.info("getWidgetDataWithDate > {} > {} > {}", new Object[]{widgetId, startDate, endDate});
        return WidgetData.builder().name("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432").id(widgetId).widgetItems(this.getTestMap()).build();
    }

    @GetMapping(value={"/list"})
    public DashBoardComponents getWidgetList() {
        ArrayList<Widget> list = new ArrayList<Widget>();
        list.add(Widget.builder().name("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u043e\u043d\u043b\u0430\u0439\u043d").id("DEVICE_ONLINE").dataUrl("/api/v2/dashboard/data/DEVICE_ONLINE").widgetType(WidgetType.SIMPLE_DATA).build());
        list.add(Widget.builder().name("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432").id("DEVICE_STATE").dataUrl("/api/v2/dashboard/data/DEVICE_STATE").widgetType(WidgetType.RING_DATAGRAM).build());
        list.add(Widget.builder().name("\u041e\u0442\u043f\u0435\u0447\u0430\u0442\u0430\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u0439 \u0441\u0435\u0433\u043e\u0434\u043d\u044f").id("PRINTED_JOBS").dataUrl("/api/v2/dashboard/data/PRINTED_JOBS").widgetType(WidgetType.SIMPLE_DATA).build());
        return DashBoardComponents.builder().widgets(list).build();
    }

    private Map<String, WidgetItem> getTestMap() {
        HashMap<String, WidgetItem> map = new HashMap<String, WidgetItem>();
        map.put("ONLINE", WidgetItem.builder().itemColor("green").legendName("\u041e\u043d\u043b\u0430\u0439\u043d").itemValue(10.0).build());
        map.put("OFLINE", WidgetItem.builder().itemColor("rad").legendName("\u041e\u0444\u043b\u0430\u0439\u043d").itemValue(7.0).build());
        return map;
    }
}

