/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.util.ThreadPoolRequest;
import ru.interunity.eyprint.ps.util.ThreadPoolThread;

public class ThreadPool {
    static Logger log = LoggerFactory.getLogger(ThreadPool.class);
    Vector objects = new Vector();
    ThreadPoolThread[] poolThreads;
    boolean terminated = false;

    public ThreadPool(int n) {
        this.poolThreads = new ThreadPoolThread[n];
        for (int i = 0; i < n; ++i) {
            this.poolThreads[i] = new ThreadPoolThread(this, i);
            this.poolThreads[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable target) {
        if (this.terminated) {
            throw new IllegalStateException("Thread pool has shutdown");
        }
        Vector vector = this.objects;
        synchronized (vector) {
            this.objects.addElement(new ThreadPoolRequest(target));
            this.objects.notify();
        }
    }

    void waitForAll(boolean terminate) {
        if (terminate) {
            for (int i = 0; i < this.poolThreads.length; ++i) {
                this.poolThreads[i].setEventsStillFiring(false);
            }
            this.terminated = true;
        }
    }

    public void closePool() {
        this.waitForAll(false);
    }

    public int getQueueSize() {
        return this.objects.size();
    }
}

