/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.exception.ObjectNotFoundException;
import ru.interunity.eyprint.ps.util.QueuedObject;

public class Queue {
    static Logger log = LoggerFactory.getLogger(Queue.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    protected static long counter = 0L;
    protected String name;
    protected final List<QueuedObject> queue = new Vector();

    public Queue(String name) {
        this.name = name;
    }

    public long add(Object object) {
        String METHOD = "void add(Object object)";
        log.debug("entry[void add(Object object)]" + NEWLINE + "  object...[" + object + "]");
        long id = counter++;
        Date timeStamp = new Date(System.currentTimeMillis());
        QueuedObject queuedObject = new QueuedObject(id, timeStamp, object);
        this.queue.add(queuedObject);
        long rval = id;
        log.debug("exit[void add(Object object)], rval[" + rval + "]");
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long id) throws ObjectNotFoundException {
        String METHOD = "Object remove(long id)";
        log.debug("entry[Object remove(long id)]" + NEWLINE + "  id...[" + id + "]");
        Object rval = null;
        List list = this.queue;
        synchronized (list) {
            boolean found = false;
            Iterator iter = this.queue.iterator();
            while (iter.hasNext()) {
                QueuedObject queuedObject = (QueuedObject)iter.next();
                long queuedObjectId = queuedObject.getId();
                if (queuedObjectId != id) continue;
                iter.remove();
                rval = queuedObject.getObject();
                found = true;
                break;
            }
            if (!found) {
                throw new ObjectNotFoundException("the object associated with id[" + id + "] was not found.");
            }
        }
        return rval;
    }

    public int size() {
        return this.queue.size();
    }

    public List<QueuedObject> list() {
        return new ArrayList<QueuedObject>(this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedObject getNext() throws ObjectNotFoundException {
        QueuedObject rval;
        String METHOD = "getNext(): ";
        List list = this.queue;
        synchronized (list) {
            if (this.queue.isEmpty()) {
                throw new ObjectNotFoundException("getNext(): The queue was empty.");
            }
            rval = (QueuedObject)this.queue.get(this.queue.size() - 1);
        }
        return rval;
    }

    public String getName() {
        return this.name;
    }
}

