/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.exception.LPDException;
import ru.interunity.eyprint.ps.util.ConfigResources;
import ru.interunity.eyprint.ps.util.FileUtil;
import ru.interunity.eyprint.ps.util.StringUtil;

public class PrintUtil {
    static Logger log = LoggerFactory.getLogger(PrintUtil.class);
    static final String CMD;
    static final String TEMP_PDF = "temp.pdf";

    public void printPDF(File filename, String printer) throws LPDException {
        String METHOD_NAME = "printPDF(): ";
        String ACROBAT = ConfigResources.getProperty((String)"ACROREAD_PROGRAM");
        if (!filename.exists()) {
            throw new LPDException("printPDF(): " + filename.getAbsolutePath() + " does not exist.");
        }
        if (StringUtil.isEmpty((String)printer)) {
            log.info("printPDF(): Printer string was empty.");
            log.info("printPDF(): Using default printer.");
            printer = "";
        }
        String command = CMD + "\"" + ACROBAT + "\" /p /h " + filename.getAbsolutePath() + " " + printer;
        log.debug("printPDF(): About to try:" + command);
        Runtime runtime = Runtime.getRuntime();
        try {
            Process pid = runtime.exec(command);
            int returnValue = pid.waitFor();
            if (0 == returnValue) {
                log.debug("printPDF(): Process successfully completed.");
            } else {
                log.warn("printPDF(): Process terminated abnomally, with an exit code of: " + returnValue);
            }
        }
        catch (InterruptedException e) {
            log.error("printPDF(): " + e.getMessage(), (Throwable)e);
            throw new LPDException("printPDF(): " + e.getMessage());
        }
        catch (IOException e) {
            log.error("printPDF(): Tried to exec " + command + " , but we failed.");
            log.error("printPDF(): " + e.getMessage(), (Throwable)e);
            throw new LPDException("printPDF(): " + e.getMessage());
        }
    }

    public void printPDF(byte[] data, String printer) throws LPDException {
        String METHOD_NAME = "printPDF(): ";
        String tempFilename = ConfigResources.getProperty((String)"TEMP_DIR") + TEMP_PDF;
        try {
            File tempFile = FileUtil.writeFile((byte[])data, (String)tempFilename);
            this.printPDF(tempFile, printer);
            if (!tempFile.delete()) {
                log.warn("printPDF(): Could not delete: " + tempFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error("printPDF(): " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        String osName = System.getProperty("os.name");
        log.debug("PrintUtil[static]: os.name=" + osName);
        CMD = osName.equals("Windows 95") || osName.equals("Windows 98") ? "command.com  /C start " : "cmd /C ";
    }
}

