/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.ui.PrintJobTableModel;
import ru.interunity.eyprint.ps.util.PrintQueue;
import ru.interunity.eyprint.ps.util.Queue;

public class PrintQueueWithTableModel
extends PrintQueue {
    static Logger log = LoggerFactory.getLogger(PrintQueueWithTableModel.class);
    private static final String CLASS = PrintQueueWithTableModel.class.getName();
    private static final String NEWLINE = System.getProperty("line.separator");
    private PrintJobTableModel printJobTableModel;

    public PrintQueueWithTableModel(String name, PrintJobTableModel printJobTableModel) {
        super(name);
        this.printJobTableModel = printJobTableModel;
    }

    public long add(PrintJob printJob) {
        long result = this.queue.add((Object)printJob);
        this.printJobTableModel.fireTableDataChanged();
        return result;
    }

    public PrintJob remove(long id) {
        PrintJob rval = null;
        try {
            rval = (PrintJob)this.queue.remove(id);
        }
        catch (Exception objectNotFoundException) {
            log.info("print job for id[" + id + "] was not found in the queue[" + this.queue.getName() + "]");
        }
        this.printJobTableModel.fireTableDataChanged();
        return rval;
    }

    public int removeAll() {
        int rval = -1;
        rval = this.size();
        this.queue = new Queue(this.queue.getName());
        this.printJobTableModel.fireTableDataChanged();
        return rval;
    }
}

