/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.ui;

import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.util.DateUtil;
import ru.interunity.eyprint.ps.util.PrintQueue;
import ru.interunity.eyprint.ps.util.QueuedPrintJobInfo;

public class PrintJobTableModel
extends AbstractTableModel {
    static Logger log = LoggerFactory.getLogger(PrintJobTableModel.class);
    private PrintQueue printQueue;
    private String[] headers = new String[]{"Job Name", "Job Number", "Size", "Date", "Owner"};

    public void setPrintQueueDataModel(PrintQueue pq) {
        this.printQueue = pq;
    }

    public int removeAllRows() {
        int result = this.printQueue.removeAll();
        this.fireTableDataChanged();
        return result;
    }

    @Override
    public int getRowCount() {
        return this.printQueue.list().size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public String getColumnName(int column) {
        String result = new String();
        if (column >= 0 && column < this.getColumnCount()) {
            result = this.headers[column];
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String METHOD_NAME = "getValueAt(): ";
        String result = null;
        List printJobs = this.printQueue.list();
        if (row >= this.getRowCount()) {
            log.warn("getValueAt(): requested row: " + row + ", only " + this.getRowCount() + " rows available");
            log.warn("getValueAt(): The PrintJob was removed from the queue before we could show it.");
        } else if (column >= this.getColumnCount()) {
            log.warn("getValueAt(): The PrintJob was removed from the queue before we could show it.");
            log.warn("getValueAt(): requested column: " + column + ", only " + this.getColumnCount() + " columns available");
        } else {
            QueuedPrintJobInfo qpji = (QueuedPrintJobInfo)printJobs.get(row);
            switch (column) {
                case 0: {
                    result = qpji.getName();
                    break;
                }
                case 1: {
                    result = String.valueOf(qpji.getId());
                    break;
                }
                case 2: {
                    result = String.valueOf(qpji.getSize());
                    break;
                }
                case 3: {
                    result = DateUtil.createDateString((Date)qpji.getTimeStamp());
                    break;
                }
                case 4: {
                    result = qpji.getOwner();
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException("requested column: " + column + ", only " + this.getColumnCount() + " columns available");
                }
            }
        }
        return result;
    }
}

