/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.servces;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import ru.interunity.ep.dao.PrinterDao;
import ru.interunity.ep.dao.QueueDao;
import ru.interunity.ep.dto.Device;
import ru.interunity.eyprint.ps.exception.QueueException;
import ru.interunity.eyprint.ps.proc.PrinterImpl;
import ru.interunity.eyprint.ps.util.Queues;

@Configuration
public class PsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PsConfiguration.class);
    private final PrinterDao printerDao;
    private final QueueDao queueDao;

    public PsConfiguration(PrinterDao printerDao, QueueDao queueDao) {
        this.printerDao = printerDao;
        this.queueDao = queueDao;
        this.startQueue();
    }

    private void startQueue() {
        List savedQueues = this.queueDao.getAllQueue();
        savedQueues.forEach(savedQueue -> {
            try {
                Device device;
                PrinterImpl printer = null;
                if (savedQueue.getDirect().booleanValue() && savedQueue.getPrinter() != 0 && (device = this.printerDao.getDevice(savedQueue.getPrinter())) != null) {
                    printer = new PrinterImpl(device.getIp(), device.getId());
                    printer.setColor(Integer.valueOf(device.getColorPrint()));
                    printer.setFormat(device.getPrintFormat());
                    printer.setModel(device.getModelId());
                }
                Queues.getInstance().createQueue(savedQueue.getQueueName(), printer);
            }
            catch (QueueException e) {
                log.warn("\u041e\u0447\u0435\u0440\u0435\u0434\u044c \u0441 \u0438\u043c\u0435\u043d\u0435\u043c {} \u043d\u0435 \u0431\u044b\u043b\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0430", (Object)savedQueue.getQueueName());
            }
        });
    }
}

