/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.servces;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.servces.ConvertingStack;
import ru.interunity.eyprint.ps.servces.PrintServerContext;
import ru.linologi.core.scp.srv.ParamLoadSrv;

public class ConverterSrv
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(ConverterSrv.class);
    private static boolean run = false;

    private ConverterSrv() {
    }

    @Override
    public void run() {
        ParamLoadSrv paramLoadSrv = (ParamLoadSrv)PrintServerContext.getBean(ParamLoadSrv.class);
        while (run) {
            ConvertingStack.ConvertOffer file = ConvertingStack.getFile();
            if (file == null) {
                this.log.info("Has no file to convert, going to sleep");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                CharSequence[] command = new String[]{"ps2pdf", file.getFilename(), paramLoadSrv.getStringParam("eyeprint.ps.converted.path") + file.getId() + ".pdf"};
                this.log.info("Try to convert file {}", (Object)file.getFilename());
                Runtime.getRuntime().exec(String.join((CharSequence)" ", command));
                ConvertingStack.rem((ConvertingStack.ConvertOffer)file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static synchronized void init() {
        if (run) {
            return;
        }
        Thread th = new Thread((Runnable)new ConverterSrv());
        th.start();
        run = true;
    }

    public static void stopConverter() {
        run = false;
    }
}

