/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.lpd;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.exception.LPDException;
import ru.interunity.eyprint.ps.lpd.CommandHandler;
import ru.interunity.eyprint.ps.lpd.CommandPrintJob;
import ru.interunity.eyprint.ps.lpd.CommandReceiveJob;
import ru.interunity.eyprint.ps.lpd.CommandRemovePrintJob;
import ru.interunity.eyprint.ps.lpd.CommandReportQueueStateLong;
import ru.interunity.eyprint.ps.lpd.CommandReportQueueStateShort;
import ru.interunity.eyprint.ps.util.StringUtil;

public class LPDCommands {
    static Logger log = LoggerFactory.getLogger(LPDCommands.class);

    public void handleCommand(byte[] command, InputStream is, OutputStream os) {
        String METHOD_NAME = "handleCommand(): ";
        CommandHandler commandHandler = null;
        try {
            commandHandler = this.createCommandHandler(command, is, os);
            commandHandler.execute();
        }
        catch (LPDException e) {
            log.error("handleCommand(): Could not properly handle command:" + command);
            log.error("handleCommand(): " + e.getMessage());
        }
    }

    private CommandHandler createCommandHandler(byte[] command, InputStream is, OutputStream os) throws LPDException {
        CommandPrintJob result;
        block8: {
            String METHOD_NAME = "createCommandHandler(): ";
            result = null;
            Vector info = StringUtil.parseCommand((byte[])command);
            try {
                if (null != info && info.size() > 0) {
                    byte[] cmd = (byte[])info.get(0);
                    if (1 == cmd[0]) {
                        log.debug("createCommandHandler(): Print Job Command");
                        result = new CommandPrintJob(command, is, os);
                        break block8;
                    }
                    if (2 == cmd[0]) {
                        log.debug("createCommandHandler(): Receive Job Command");
                        result = new CommandReceiveJob(command, is, os);
                        break block8;
                    }
                    if (3 == cmd[0]) {
                        log.debug("createCommandHandler(): Report Queue State Short Command");
                        result = new CommandReportQueueStateShort(command, is, os);
                        break block8;
                    }
                    if (4 == cmd[0]) {
                        log.debug("createCommandHandler(): Report Queue State Long Command");
                        result = new CommandReportQueueStateLong(command, is, os);
                        break block8;
                    }
                    if (5 == cmd[0]) {
                        log.debug("createCommandHandler(): Remove Print Job Command");
                        result = new CommandRemovePrintJob(command, is, os);
                        break block8;
                    }
                    throw new LPDException("createCommandHandler(): We do not support command:" + cmd);
                }
                throw new LPDException("createCommandHandler(): command passed in was bad, command=" + command);
            }
            catch (LPDException e) {
                log.error("createCommandHandler(): Could not properly handle command:" + command);
                log.error("createCommandHandler(): " + e.getMessage());
            }
        }
        return result;
    }
}

