/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.lpd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.exception.LPDException;
import ru.interunity.eyprint.ps.exception.QueueException;
import ru.interunity.eyprint.ps.lpd.CommandHandler;
import ru.interunity.eyprint.ps.util.QueuedPrintJobInfo;
import ru.interunity.eyprint.ps.util.Queues;
import ru.interunity.eyprint.ps.util.StringUtil;

public class CommandReportQueueStateShort
extends CommandHandler {
    static Logger log = LoggerFactory.getLogger(CommandReportQueueStateShort.class);

    public CommandReportQueueStateShort(byte[] command, InputStream is, OutputStream os) {
        super(command, is, os);
    }

    public void execute() throws LPDException {
        String METHOD_NAME = "execute(): ";
        Vector info = StringUtil.parseCommand((byte[])this.command);
        if (null != info && info.size() > 0) {
            byte[] cmd = (byte[])info.get(0);
            byte[] queue = (byte[])info.get(1);
            String queueName = new String(queue).trim();
            try {
                List queueudPrintJobInfos = Queues.getInstance().listAllPrintJobs(queueName);
                StringBuffer sb = new StringBuffer();
                sb.append(StringUtil.createFixedLengthString((String)"Job Id", (int)8));
                sb.append(StringUtil.createFixedLengthString((String)"Name", (int)20));
                sb.append(StringUtil.createFixedLengthString((String)"Owner", (int)15));
                sb.append("\n");
                for (QueuedPrintJobInfo queuedPrintJobInfo : queueudPrintJobInfos) {
                    sb.append(queuedPrintJobInfo.getShortDescription());
                    sb.append("\n");
                }
                if (3 != cmd[0]) {
                    throw new LPDException("execute(): cmd[0]=" + cmd[0] + ",should of been 0x3");
                }
                log.debug("execute(): Report Queue State Command Short");
                log.debug("execute(): Print Queue status short=" + sb.toString());
                this.os.write(sb.toString().getBytes());
                this.os.flush();
            }
            catch (LPDException e) {
                log.error("execute(): " + e.getMessage());
                throw new LPDException((Throwable)e);
            }
            catch (IOException e) {
                log.error("execute(): " + e.getMessage());
                throw new LPDException((Throwable)e);
            }
            catch (QueueException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new LPDException("execute(): command not understood, command=" + new String(this.command));
        }
    }
}

