/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.lpd;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.exception.LPDException;
import ru.interunity.eyprint.ps.lpd.CommandHandler;
import ru.interunity.eyprint.ps.util.QueuedPrintJobInfo;
import ru.interunity.eyprint.ps.util.Queues;
import ru.interunity.eyprint.ps.util.StringUtil;

public class CommandRemovePrintJob
extends CommandHandler {
    static Logger log = LoggerFactory.getLogger(CommandRemovePrintJob.class);

    public CommandRemovePrintJob(byte[] command, InputStream is, OutputStream os) {
        super(command, is, os);
    }

    public void execute() throws LPDException {
        String METHOD_NAME = "execute(): ";
        Vector info = StringUtil.parseCommand((byte[])this.command);
        if (null != info && info.size() > 1) {
            byte[] cmd = (byte[])info.get(0);
            byte[] queue = (byte[])info.get(1);
            byte[] user = (byte[])info.get(2);
            byte[] jobNumber = new byte[]{};
            String queueName = new String(queue).trim();
            String userName = new String(user).trim();
            String jobId = new String();
            try {
                if (info.size() > 2) {
                    jobNumber = (byte[])info.get(3);
                    jobId = new String(jobNumber);
                } else {
                    List queueudPrintJobInfos = Queues.getInstance().listAllPrintJobs(queueName);
                    QueuedPrintJobInfo queuedPrintJobInfo = (QueuedPrintJobInfo)queueudPrintJobInfos.get(queueudPrintJobInfos.size() - 1);
                    jobId = String.valueOf(queuedPrintJobInfo.getId());
                }
                if (5 != cmd[0]) {
                    throw new LPDException("execute(): cmd[0]=" + cmd[0] + ",should of been 0x5");
                }
                log.debug("execute(): Remove Print Job Command");
                Queues.getInstance().removePrintJob(queueName, userName, jobId);
            }
            catch (Exception e) {
                log.error("execute(): " + e.getMessage());
                throw new LPDException((Throwable)e);
            }
        } else {
            throw new LPDException("execute(): command not understood, command=" + new String(this.command));
        }
    }
}

