/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.lpd;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.ep.dao.UserPSDao;
import ru.interunity.ep.dto.PrintPermissionDto;
import ru.interunity.eyprint.ps.common.Constants;
import ru.interunity.eyprint.ps.common.ControlFile;
import ru.interunity.eyprint.ps.common.DataFile;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.exception.LPDException;
import ru.interunity.eyprint.ps.exception.QueueException;
import ru.interunity.eyprint.ps.lpd.CommandHandler;
import ru.interunity.eyprint.ps.servces.PrintServerContext;
import ru.interunity.eyprint.ps.util.JobUtil;
import ru.interunity.eyprint.ps.util.NetUtil;
import ru.interunity.eyprint.ps.util.Queues;
import ru.interunity.eyprint.ps.util.StringUtil;
import ru.linologi.core.scp.srv.ParamLoadSrv;

public class CommandReceiveJob
extends CommandHandler {
    static Logger log = LoggerFactory.getLogger(CommandReceiveJob.class);
    UserPSDao userPSDao = (UserPSDao)PrintServerContext.getBean(UserPSDao.class);

    public CommandReceiveJob(byte[] command, InputStream is, OutputStream os) {
        super(command, is, os);
    }

    public void execute() throws LPDException {
        String METHOD_NAME = "execute(): ";
        Vector info = StringUtil.parseCommand((byte[])this.command);
        if (info.size() > 1) {
            byte[] cmd = (byte[])info.get(0);
            byte[] queue = (byte[])info.get(1);
            String queueName = new String(queue).trim();
            if (2 != cmd[0]) {
                throw new LPDException("execute(): command passed in was bad, cmd[0]=" + new String(cmd));
            }
            if (StringUtil.isEmpty((String)queueName)) {
                throw new LPDException("execute(): queueName passed in was empty for command=" + new String(this.command));
            }
            try {
                this.os.write(Constants.ACK);
                log.debug("execute(): Receive Job Command");
                PrintJob job = this.receivePrintJob(this.is, this.os);
                log.info("Start permission validation");
                this.printPermissionValidation(job, queueName);
            }
            catch (IOException | QueueException e) {
                log.error("execute(): " + e.getMessage());
                throw new LPDException("execute(): " + e.getMessage());
            }
        } else {
            throw new LPDException("execute(): command not understood, command=" + new String(this.command));
        }
    }

    public void printPermissionValidation(PrintJob job, String queueName) throws QueueException {
        String systemUserName = job.getOwner();
        Boolean canColor = true;
        Boolean canNoDuplex = true;
        PrintPermissionDto permission = this.userPSDao.getPrintPermission(systemUserName);
        log.info("Start permision validation:");
        log.info("permission: " + permission);
        log.info("permission.isPrintPermission(): " + permission.isPrintPermission());
        log.info("job.getIsColor(): " + job.getIsColor());
        log.info("job.getIsDuplex(): " + job.getIsDuplex());
        if (permission.isPrintPermission()) {
            if (job.getIsColor().booleanValue()) {
                canColor = permission.isColorPrintPermission();
                log.info("Check color print permission: job.getIsColor(): " + job.getIsColor() + ", permission color print: " + canColor);
            }
            if (!job.getIsDuplex().booleanValue()) {
                canNoDuplex = !permission.isDuplexPermission();
                log.info("Check only duplex print permission: job.getIsDuplex(): " + job.getIsDuplex() + ", not only duplex print: " + canNoDuplex);
            }
            if (canColor.booleanValue() && canNoDuplex.booleanValue()) {
                log.info("Permission is valid. Start printing file!");
                Queues.getInstance().addPrintJob(queueName, job);
            } else {
                log.info("Permission is not valid.User with username " + systemUserName + " have permission: color print = " + canColor + ", not only duplex print = " + canNoDuplex + ". Priny job have permission parametr: job.getIsColor(): " + job.getIsColor() + ",  job.getIsDuplex(): " + job.getIsDuplex());
            }
        } else {
            log.info("User with username " + systemUserName + " does not have rights to printing");
        }
    }

    private PrintJob receivePrintJob(InputStream is, OutputStream os) throws LPDException {
        String METHOD_NAME = "receivePrintJob(): ";
        PrintJob printJob = null;
        ControlFile controlFile = null;
        DataFile dataFile = null;
        try {
            NetUtil netUtil = new NetUtil();
            for (int i = 1; i <= 2; ++i) {
                byte[] receiveInput = netUtil.readNextInput(is, os);
                Vector cmd = StringUtil.parseCommand((byte[])receiveInput);
                if (receiveInput[0] == 2) {
                    controlFile = this.setControlFile(is, os, cmd);
                    continue;
                }
                if (receiveInput[0] != 3) continue;
                dataFile = this.setDataFile(is, os, cmd);
            }
        }
        catch (Exception ex) {
            log.error("receivePrintJob(): problems reading Input");
        }
        if (null != controlFile && null != dataFile) {
            printJob = new PrintJob(controlFile, dataFile);
            try {
                ParamLoadSrv paramSrv = (ParamLoadSrv)PrintServerContext.getBean(ParamLoadSrv.class);
                Boolean enabled = paramSrv.getBooleanParam("eyeprint.ps.serialise.enabled", false);
                if (Boolean.TRUE.equals(enabled)) {
                    FileOutputStream fileOut = new FileOutputStream(paramSrv.getStringParam("eyeprint.ps.serialise.path") + printJob.hashCode() + ".ser");
                    ObjectOutputStream out = new ObjectOutputStream(fileOut);
                    out.writeObject(printJob);
                    out.close();
                    fileOut.close();
                }
            }
            catch (Exception ex) {
                log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
            }
        }
        String jobContens = new String(printJob.getDataFile().getContents());
        printJob.setIsColor(JobUtil.isJobContentColor((String)jobContens));
        printJob.setIsDuplex(JobUtil.isJobDuplex((String)jobContens));
        return printJob;
    }

    private ControlFile setControlFile(InputStream is, OutputStream os, Vector<byte[]> cmd) throws LPDException {
        String METHOD_NAME = "setControlFile(): ";
        try {
            NetUtil netUtil = new NetUtil();
            String controlFileSize = new String(cmd.get(1));
            String controlFileHeader = new String(cmd.get(2));
            Vector headerVector = StringUtil.parsePrintFileName((String)controlFileHeader);
            if (headerVector.size() == 3) {
                byte[] cFile = netUtil.readControlFile(is, os);
                ControlFile controlFile = new ControlFile();
                controlFile.setCount(controlFileSize);
                controlFile.setJobNumber((String)headerVector.get(1));
                controlFile.setHostName((String)headerVector.get(2));
                controlFile.setContents(cFile);
                log.debug("setControlFile(): Control File=" + new String(cFile));
                controlFile.setControlFileCommands(cFile);
                log.debug("setControlFile(): Control File Commands=" + controlFile.getControlFileCommands().toString());
                return controlFile;
            }
            throw new LPDException("setControlFile(): controlFileHeader did not parse properly, controlFileHeader=" + controlFileHeader);
        }
        catch (IOException e) {
            log.error("setControlFile(): Had trouble receiving the control file.");
            log.error("setControlFile(): " + e.getMessage());
            throw new LPDException((Throwable)e);
        }
    }

    private DataFile setDataFile(InputStream is, OutputStream os, Vector<byte[]> cmd) throws LPDException {
        String METHOD_NAME = "setDataFile(): ";
        try {
            NetUtil netUtil = new NetUtil();
            String dataFileSize = new String(cmd.get(1));
            log.info("setDataFile(): DataFile size=" + dataFileSize);
            String dataFileHeader = new String(cmd.get(2));
            Vector headerVector = StringUtil.parsePrintFileName((String)dataFileHeader);
            if (headerVector.size() == 3) {
                long dfSize = 0L;
                try {
                    dfSize = Long.parseLong(dataFileSize);
                }
                catch (NumberFormatException e) {
                    log.error("setDataFile(): " + e.getMessage());
                }
                byte[] dFile = 0L == dfSize ? netUtil.readPrintFile(is, os) : netUtil.readPrintFile(is, os, dfSize);
                DataFile dataFile = new DataFile();
                dataFile.setCount(dataFileSize);
                dataFile.setHostName((String)headerVector.get(2));
                dataFile.setJobNumber((String)headerVector.get(1));
                dataFile.setContents(dFile);
                return dataFile;
            }
            throw new LPDException("setDataFile(): dataFileHeader did not parse properly, dataFileHeader=" + dataFileHeader);
        }
        catch (IOException e) {
            log.error("setDataFile(): Had trouble receiving the data file.");
            log.error("setDataFile(): " + e.getMessage());
            throw new LPDException((Throwable)e);
        }
    }
}

