/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.common;

import java.io.Serializable;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.common.ControlFile;
import ru.interunity.eyprint.ps.common.DataFile;
import ru.interunity.eyprint.ps.exception.LPDException;

public class PrintJob
implements Serializable,
Cloneable {
    static Logger log = LoggerFactory.getLogger(PrintJob.class);
    private BigInteger eyeprintJobId;
    private long eyeprintPrinterId;
    private ControlFile controlFile;
    private DataFile dataFile;
    private String pdfPath;
    private Integer pageCount;
    private String printFormat;
    private Double price;
    private Boolean isColor;
    private Boolean isDuplex;

    public PrintJob(ControlFile cf, DataFile df) throws LPDException {
        this.controlFile = cf;
        this.dataFile = df;
    }

    public String getName() {
        return this.controlFile.getControlFileCommands().getJobName();
    }

    public int getSize() {
        return this.dataFile.getContents().length;
    }

    public String getOwner() {
        return this.controlFile.getControlFileCommands().getUserId();
    }

    public ControlFile getControlFile() {
        return this.controlFile;
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public Object clone() {
        PrintJob result;
        try {
            result = (PrintJob)super.clone();
            result.controlFile = (ControlFile)this.controlFile.clone();
            result.dataFile = (DataFile)this.dataFile.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error(e.getMessage());
            throw new InternalError(e.getMessage());
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (null != this.controlFile) {
            sb.append(", ControlFile:\n");
            sb.append(this.controlFile.getContents());
        } else {
            sb.append(", controlFile is null");
        }
        if (null != this.dataFile) {
            sb.append(", DataFile:\n");
            sb.append(this.dataFile.getContents());
        } else {
            sb.append(", dataFile is null");
        }
        return sb.toString();
    }

    public void setEyeprintJobId(BigInteger eyeprintJobId) {
        this.eyeprintJobId = eyeprintJobId;
    }

    public BigInteger getEyeprintJobId() {
        return this.eyeprintJobId;
    }

    public void setEyeprintPrinterId(long eyeprintPrinterId) {
        this.eyeprintPrinterId = eyeprintPrinterId;
    }

    public long getEyeprintPrinterId() {
        return this.eyeprintPrinterId;
    }

    public void setPdfPath(String pdfPath) {
        this.pdfPath = pdfPath;
    }

    public String getPdfPath() {
        return this.pdfPath;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPrintFormat(String printFormat) {
        this.printFormat = printFormat;
    }

    public String getPrintFormat() {
        return this.printFormat;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setIsColor(Boolean isColor) {
        this.isColor = isColor;
    }

    public Boolean getIsColor() {
        return this.isColor;
    }

    public void setIsDuplex(Boolean isDuplex) {
        this.isDuplex = isDuplex;
    }

    public Boolean getIsDuplex() {
        return this.isDuplex;
    }
}

