/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.text.DecimalFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.util.DateUtil;
import ru.interunity.eyprint.ps.util.QueuedObject;
import ru.interunity.eyprint.ps.util.StringUtil;

public class QueuedPrintJobInfo {
    static Logger log = LoggerFactory.getLogger(QueuedPrintJobInfo.class);
    private static final String CLASS = QueuedPrintJobInfo.class.getName();
    private static final String NEWLINE = System.getProperty("line.separator");
    private long id;
    private Date timeStamp;
    private int size;
    private String name;
    private String owner;

    public QueuedPrintJobInfo(QueuedObject queuedObject) {
        String METHOD = "QueuedPrintJobInfo(QueuedObject queuedObject)";
        this.id = queuedObject.getId();
        this.timeStamp = queuedObject.getTimeStamp();
        PrintJob printJob = (PrintJob)queuedObject.getObject();
        this.size = printJob.getSize();
        this.name = printJob.getName();
        this.owner = printJob.getOwner();
    }

    public long getId() {
        return this.id;
    }

    public Date getTimeStamp() {
        return (Date)this.timeStamp.clone();
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public static String singleLine(QueuedPrintJobInfo o) {
        return o.getId() + ", " + o.getName() + ", " + o.getTimeStamp() + ", " + o.getSize() + ", " + o.getOwner();
    }

    public String getShortDescription() {
        DecimalFormat df = new DecimalFormat("000");
        String jobId = df.format(this.id);
        StringBuffer sb = new StringBuffer();
        sb.append(StringUtil.createFixedLengthString((String)jobId, (int)8));
        sb.append(StringUtil.createFixedLengthString((String)this.name, (int)20));
        sb.append(StringUtil.createFixedLengthString((String)this.owner, (int)15));
        return sb.toString();
    }

    public String getLongDescription() {
        DecimalFormat df = new DecimalFormat("000");
        String jobId = df.format(this.id);
        String jobSize = df.format(this.size);
        StringBuffer sb = new StringBuffer();
        sb.append(StringUtil.createFixedLengthString((String)jobId, (int)8));
        sb.append(StringUtil.createFixedLengthString((String)this.name, (int)20));
        sb.append(StringUtil.createFixedLengthString((String)this.owner, (int)15));
        sb.append(StringUtil.createFixedLengthString((String)DateUtil.createDateString((Date)this.timeStamp), (int)20));
        sb.append(StringUtil.createFixedLengthString((String)jobSize, (int)9));
        return sb.toString();
    }

    public String toString() {
        int JOB_NAME_LENGTH = 10;
        int OWNER_LENGTH = 10;
        DecimalFormat df = new DecimalFormat("000");
        String jobId = df.format(this.id);
        String jobSize = df.format(this.size);
        StringBuffer sb = new StringBuffer();
        sb.append("Job Id [");
        sb.append(jobId);
        sb.append("] ");
        sb.append("Name [");
        sb.append(StringUtil.createFixedLengthString((String)this.name, (int)10));
        sb.append("] ");
        sb.append("Size [");
        sb.append(jobSize);
        sb.append("] ");
        sb.append("Owner [");
        sb.append(StringUtil.createFixedLengthString((String)this.owner, (int)10));
        sb.append("] ");
        sb.append("Date [");
        sb.append(DateUtil.createDateString((Date)this.timeStamp));
        sb.append("] ");
        return sb.toString();
    }
}

