/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.common.Lock;
import ru.interunity.eyprint.ps.common.PrintJob;
import ru.interunity.eyprint.ps.exception.ObjectNotFoundException;
import ru.interunity.eyprint.ps.util.Queue;
import ru.interunity.eyprint.ps.util.QueuedObject;
import ru.interunity.eyprint.ps.util.QueuedPrintJob;
import ru.interunity.eyprint.ps.util.QueuedPrintJobInfo;

public class PrintQueue {
    static Logger log = LoggerFactory.getLogger(PrintQueue.class);
    private static final String CLASS = PrintQueue.class.getName();
    private static final String NEWLINE = System.getProperty("line.separator");
    protected final Lock lock;
    protected Queue queue;
    protected String name;

    public PrintQueue(String name) {
        this.name = name;
        this.queue = new Queue(name);
        this.lock = new Lock(name);
    }

    public String getName() {
        return this.name;
    }

    public Lock getLock() {
        return this.lock;
    }

    public long add(PrintJob printJob) {
        return this.queue.add((Object)printJob);
    }

    public PrintJob remove(long id) throws ObjectNotFoundException {
        PrintJob rval = null;
        try {
            rval = (PrintJob)this.queue.remove(id);
        }
        catch (Exception objectNotFoundException) {
            log.info("print job for id[" + id + "] was not found in the queue[" + this.queue.getName() + "]");
            throw objectNotFoundException;
        }
        return rval;
    }

    public QueuedPrintJob getNextPrintJob() {
        QueuedPrintJob rval = null;
        try {
            QueuedObject queuedObject = this.queue.getNext();
            long queueId = queuedObject.getId();
            PrintJob printJob = (PrintJob)queuedObject.getObject();
            rval = new QueuedPrintJob(queueId, (PrintJob)printJob.clone());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rval;
    }

    public int removeAll() {
        int rval = -1;
        rval = this.size();
        this.queue = new Queue(this.queue.getName());
        return rval;
    }

    public int size() {
        return this.queue.size();
    }

    public List<QueuedPrintJobInfo> list() {
        Vector<QueuedPrintJobInfo> list = new Vector<QueuedPrintJobInfo>();
        List qlist = this.queue.list();
        for (QueuedObject queuedObject : qlist) {
            QueuedPrintJobInfo queuedPrintJobInfo = new QueuedPrintJobInfo(queuedObject);
            list.add(queuedPrintJobInfo);
        }
        Vector<QueuedPrintJobInfo> rval = list;
        return rval;
    }

    public void closeQueue() {
        this.notifyAll();
    }
}

