/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyprint.ps.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.interunity.eyprint.ps.common.Constants;

public class NetUtil {
    static Logger log = LoggerFactory.getLogger(NetUtil.class);

    public byte[] readCommand(InputStream is) throws IOException {
        String METHOD_NAME = "readCommand(): ";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int data = is.read();
        while (-1 != data && 10 != data) {
            baos.write(data);
            data = is.read();
        }
        if (10 == data) {
            baos.write(data);
        }
        log.debug("readCommand(): Command = " + baos.toString());
        return baos.toByteArray();
    }

    public byte[] readNextInput(InputStream is, OutputStream os) throws IOException {
        String METHOD_NAME = "readNextInput(): ";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int data = is.read();
        while (-1 != data && 10 != data) {
            baos.write(data);
            data = is.read();
        }
        if (10 == data) {
            baos.write(data);
        }
        log.debug("readNextInput(): Command = " + baos.toString());
        os.write(Constants.ACK);
        return baos.toByteArray();
    }

    public byte[] readControlFile(InputStream is, OutputStream os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int data = is.read();
        while (-1 != data && 0 != data) {
            baos.write(data);
            data = is.read();
        }
        os.write(Constants.ACK);
        return baos.toByteArray();
    }

    public byte[] readPrintFile(InputStream is, OutputStream os) throws IOException {
        String METHOD_NAME = "readPrintFile(): ";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int data = is.read();
        while (-1 != data && 0 != data) {
            baos.write(data);
            data = is.read();
        }
        os.write(Constants.ACK);
        return baos.toByteArray();
    }

    public byte[] readPrintFile(InputStream is, OutputStream os, long size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int data = is.read();
        int count = 1;
        while (-1 != data && size >= (long)count) {
            baos.write(data);
            data = is.read();
            ++count;
        }
        os.write(Constants.ACK);
        return baos.toByteArray();
    }
}

