/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyeprint.service.srv;

import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import ru.interunity.ep.alertmonitoringOA.eyprint.alertmonitor.AlertWorker;
import ru.interunity.ep.allscan.AllScanWorker;
import ru.interunity.ep.license.LicenseObj;
import ru.interunity.ep.service.CommonEmailServiceImpl;
import ru.interunity.ep.suppliesmonitoringOA.SuppliesWorker;
import ru.linologi.core.scp.srv.ParamLoadSrv;

@Component
public class AlertMonitoringSrv {
    private LocalDateTime nextRunScaner = LocalDateTime.now();
    private LocalDateTime nextRunSuppliesWorker = LocalDateTime.now();
    private LocalDateTime nextRunAlertWorker = LocalDateTime.now();
    private final ParamLoadSrv paramLoadSrv;
    private final AlertWorker alertWorker;
    private final SuppliesWorker suppliesWorker;
    private final AllScanWorker allScanWorker;
    private final CommonEmailServiceImpl commonEmailService;
    private final LicenseObj licenseObj;
    private static final Logger log = LoggerFactory.getLogger(AlertMonitoringSrv.class);

    public AlertMonitoringSrv(ParamLoadSrv paramLoadSrv, AlertWorker alertWorker, SuppliesWorker suppliesWorker, AllScanWorker allScanWorker, CommonEmailServiceImpl commonEmailService, LicenseObj licenseObj) {
        this.paramLoadSrv = paramLoadSrv;
        this.alertWorker = alertWorker;
        this.suppliesWorker = suppliesWorker;
        this.allScanWorker = allScanWorker;
        this.commonEmailService = commonEmailService;
        this.licenseObj = licenseObj;
    }

    @Scheduled(cron="${eyeprint.service.check.license}")
    public void checkLicense() {
        if (this.licenseObj.getExpirationDate().isAfter(LocalDateTime.now())) {
            log.info("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u0430");
        } else {
            log.info("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u0438\u0441\u0442\u0435\u043a\u043b\u0430");
        }
    }

    @Scheduled(fixedRateString="${eyeprint.service.alert.fixedRate}")
    public void startDemonA() {
        if (this.nextRunAlertWorker.isAfter(LocalDateTime.now())) {
            return;
        }
        log.info("Start alert monitoring");
        try {
            this.alertWorker.start();
        }
        catch (Exception e) {
            log.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u0441\u0431\u043e\u0440\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\u0445", (Throwable)e);
        }
        int rate = this.paramLoadSrv.getIntParam("eyeprint.alert.timeout", 60);
        this.nextRunAlertWorker = LocalDateTime.now().plusSeconds(rate);
        log.info("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a \u0441\u0431\u043e\u0440\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\u0445 {}", (Object)this.nextRunAlertWorker);
    }

    @Scheduled(fixedRate=1000L)
    public void startDemonS() {
        if (this.nextRunSuppliesWorker.isAfter(LocalDateTime.now())) {
            return;
        }
        log.info("Start supplies monitoring");
        try {
            this.suppliesWorker.start();
        }
        catch (Exception e) {
            log.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0431\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e \u0440\u0430\u0441\u0445\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432", (Throwable)e);
        }
        int rate = this.paramLoadSrv.getIntParam("eyeprint.supplies.timeout", 60);
        this.nextRunSuppliesWorker = LocalDateTime.now().plusSeconds(rate);
        log.info("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a \u0441\u0431\u043e\u0440\u0430 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u043e\u0432 {}", (Object)this.nextRunSuppliesWorker);
    }

    @Scheduled(cron="${eyeprint.service.critmail}")
    @Async
    public void startDemonMail() {
        log.info("Send critical supplies");
        this.suppliesWorker.startEmailInfo();
    }

    @Scheduled(fixedRate=1000L)
    public void startDemonN() {
        if (this.nextRunScaner.isAfter(LocalDateTime.now())) {
            return;
        }
        log.info("Start all_scan monitoring");
        try {
            this.allScanWorker.start();
        }
        catch (Exception e) {
            log.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0435\u0442\u0438", (Throwable)e);
        }
        int rate = this.paramLoadSrv.getIntParam("eyeprint.net_scaner.timeout", 60);
        this.nextRunScaner = LocalDateTime.now().plusSeconds(rate);
        log.info("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0435\u0442\u0438 {}", (Object)this.nextRunScaner);
    }

    @Scheduled(cron="${eyeprint.service.mail}")
    @Async
    public void startDemonM() {
        log.info("Start email sending");
        List list = this.paramLoadSrv.getArray("");
        list.forEach(arg_0 -> ((CommonEmailServiceImpl)this.commonEmailService).sendSimpleMessageForSchemasInfo(arg_0));
    }
}

