/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyeprint.service.srv;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dao.PrinterDao;
import ru.interunity.ep.dao.SnmpCredentialDao;
import ru.interunity.ep.dto.Device;
import ru.interunity.ep.dto.DeviceAdditionalCounter;
import ru.interunity.ep.dto.printer.SnmpCredentialDto;
import ru.interunity.ep.printjobDao.dao.DeviceCounterDao;
import ru.interunity.ep.snmp.srv.XeroxCounterLoader;

@Component
public class AdditionalCounterSrv {
    private static final Logger log = LoggerFactory.getLogger(AdditionalCounterSrv.class);
    private LocalDateTime nextRun = LocalDateTime.now();
    private final PrinterDao printerDao;
    private final DeviceCounterDao deviceCounterDao;
    private final SnmpCredentialDao snmpCredentialDao;
    private final XeroxCounterLoader xeroxCounterLoader;

    @Scheduled(fixedRate=1000L)
    public void updateDeviceCounter() {
        if (this.nextRun.isAfter(LocalDateTime.now())) {
            return;
        }
        try {
            List list = this.printerDao.getDevList();
            for (Device device : list) {
                try {
                    SnmpCredentialDto snmpCredential;
                    if (device.getState() == 0) continue;
                    log.info("\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u043c \u0441\u0431\u043e\u0440 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u043e\u0432 \u0434\u043b\u044f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 {} \u0441 \u0438\u043c\u0435\u043d\u0435\u043c {}", (Object)device.getId(), (Object)device.getName());
                    List counters = this.deviceCounterDao.getCountersByDeviceId(device.getId());
                    Map refs = counters.stream().collect(Collectors.toMap(DeviceAdditionalCounter::getOid, Function.identity()));
                    try {
                        snmpCredential = this.snmpCredentialDao.getSnmpCredential(device.getId());
                    }
                    catch (Exception ex) {
                        snmpCredential = SnmpCredentialDto.builder().community("public").port(161).version("v2").build();
                    }
                    if (snmpCredential != null && device.getVendor() == 253) {
                        try {
                            List counterListFromDevice = this.xeroxCounterLoader.getXeroxCounters(device, snmpCredential);
                            ArrayList counterToSave = new ArrayList();
                            counterListFromDevice.forEach(counter -> {
                                if (refs.containsKey(counter.getOid())) {
                                    DeviceAdditionalCounter savedCounter = (DeviceAdditionalCounter)refs.get(counter.getOid());
                                    if (savedCounter.getLastCounterValue().compareTo(counter.getLastCounterValue()) != 0) {
                                        savedCounter.setLastCounterValue(counter.getLastCounterValue());
                                        counter.setCounterId(savedCounter.getCounterId());
                                        counterToSave.add(counter);
                                    }
                                } else {
                                    counter.setDeviceId(device.getId());
                                    this.deviceCounterDao.writeCounter(Collections.singletonList(counter));
                                }
                            });
                            log.info("\u0414\u043b\u044f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e {} \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u043e\u0432, \u0434\u043b\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f {}", (Object)counterListFromDevice.size(), (Object)counterToSave.size());
                            if (counterToSave.isEmpty()) continue;
                            counterToSave.forEach(counter -> counter.setDeviceId(device.getId()));
                            this.deviceCounterDao.writeCounter(counterToSave);
                            this.deviceCounterDao.addCounterHistoryRecord(counterToSave);
                        }
                        catch (Exception e) {
                            log.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u043e\u0432 \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 {}", (Object)device.getId(), (Object)e);
                        }
                        continue;
                    }
                    log.warn("\u0414\u043b\u044f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a snmp!", (Object)device.getId());
                }
                catch (Exception e) {
                    log.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0434\u043b\u044f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 {}", (Object)device.getId(), (Object)e);
                }
            }
            this.nextRun = LocalDateTime.now().plusSeconds(60L);
            log.info("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a \u0441\u0431\u043e\u0440\u0430 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u043e\u0432 {}", (Object)this.nextRun);
        }
        catch (Exception e) {
            log.warn("\u0427\u0442\u043e \u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a ");
        }
    }

    public AdditionalCounterSrv(PrinterDao printerDao, DeviceCounterDao deviceCounterDao, SnmpCredentialDao snmpCredentialDao, XeroxCounterLoader xeroxCounterLoader) {
        this.printerDao = printerDao;
        this.deviceCounterDao = deviceCounterDao;
        this.snmpCredentialDao = snmpCredentialDao;
        this.xeroxCounterLoader = xeroxCounterLoader;
    }
}

