/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.browser.MibNode;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibTreeBuilder {
    private static MibTreeBuilder instance = null;
    private JTree mibTree = null;
    private HashMap nodes = new HashMap();

    public static MibTreeBuilder getInstance() {
        if (instance == null) {
            instance = new MibTreeBuilder();
        }
        return instance;
    }

    private MibTreeBuilder() {
        int mode = 1;
        this.mibTree = new MibTree();
        this.mibTree.setToolTipText("");
        this.mibTree.getSelectionModel().setSelectionMode(mode);
        this.mibTree.setRootVisible(false);
    }

    public JTree getTree() {
        return this.mibTree;
    }

    public MibNode getNode(MibSymbol symbol) {
        return (MibNode)this.nodes.get(symbol);
    }

    public void addMib(Mib mib) {
        Iterator iter = mib.getAllSymbols().iterator();
        MibNode node = new MibNode("VALUES", null);
        JTree valueTree = new JTree(node);
        while (iter.hasNext()) {
            MibSymbol symbol = (MibSymbol)iter.next();
            this.addSymbol(valueTree.getModel(), symbol);
        }
        MibNode root = (MibNode)this.mibTree.getModel().getRoot();
        node = new MibNode(mib.getName(), null);
        node.add((MibNode)valueTree.getModel().getRoot());
        root.add(node);
    }

    private void addSymbol(TreeModel model, MibSymbol symbol) {
        MibValue value;
        if (symbol instanceof MibValueSymbol && (value = ((MibValueSymbol)symbol).getValue()) instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue oid = (ObjectIdentifierValue)value;
            this.addToTree(model, oid);
        }
    }

    private MibNode addToTree(TreeModel model, ObjectIdentifierValue oid) {
        MibNode node;
        MibNode parent = this.hasParent(oid) ? this.addToTree(model, oid.getParent()) : (MibNode)model.getRoot();
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            node = (MibNode)model.getChild(parent, i);
            if (!node.getValue().equals(oid)) continue;
            return node;
        }
        String name = oid.getName() + " (" + oid.getValue() + ")";
        node = new MibNode(name, oid);
        parent.add(node);
        this.nodes.put(oid.getSymbol(), node);
        return node;
    }

    private boolean hasParent(ObjectIdentifierValue oid) {
        ObjectIdentifierValue parent = oid.getParent();
        return oid.getSymbol() != null && oid.getSymbol().getMib() != null && parent != null && parent.getSymbol() != null && parent.getSymbol().getMib() != null && parent.getSymbol().getMib().equals(oid.getSymbol().getMib());
    }

    public boolean unloadMib(String mibName) {
        DefaultTreeModel model = (DefaultTreeModel)this.mibTree.getModel();
        MibNode tempNode = null;
        MibNode root = (MibNode)model.getRoot();
        Enumeration<TreeNode> e = root.preorderEnumeration();
        while (e.hasMoreElements()) {
            tempNode = (MibNode)e.nextElement();
            if (tempNode.getValue() != null || !tempNode.getName().equals(mibName)) continue;
            this.removeNodes(tempNode);
            model.removeNodeFromParent(tempNode);
            return true;
        }
        return false;
    }

    public void unloadAllMibs() {
        this.nodes.clear();
        ((MibNode)this.mibTree.getModel().getRoot()).removeAllChildren();
    }

    private void removeNodes(MibNode root) {
        Iterator iter = this.nodes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            MibNode node = (MibNode)entry.getValue();
            if (!node.isNodeDescendant(root)) continue;
            iter.remove();
        }
    }

    private class MibTree
    extends JTree {
        public MibTree() {
            super(new MibNode("Mibble Browser", null));
        }

        public String getToolTipText(MouseEvent e) {
            if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
                return null;
            }
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            MibNode node = (MibNode)path.getLastPathComponent();
            return node.getToolTipText();
        }
    }
}

