/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.TokenPattern;

public class Token
extends Node {
    private TokenPattern pattern;
    private String image;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;
    private Token previous = null;
    private Token next = null;

    public Token(TokenPattern pattern, String image, int line, int col) {
        this.pattern = pattern;
        this.image = image;
        this.startLine = line;
        this.startColumn = col;
        this.endLine = line;
        this.endColumn = col + image.length() - 1;
        int pos = 0;
        while (image.indexOf(10, pos) >= 0) {
            pos = image.indexOf(10, pos) + 1;
            ++this.endLine;
            this.endColumn = image.length() - pos;
        }
    }

    public int getId() {
        return this.pattern.getId();
    }

    public String getName() {
        return this.pattern.getName();
    }

    public String getImage() {
        return this.image;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    TokenPattern getPattern() {
        return this.pattern;
    }

    public Token getPreviousToken() {
        return this.previous;
    }

    void setPreviousToken(Token previous) {
        if (this.previous != null) {
            this.previous.next = null;
        }
        this.previous = previous;
        if (previous != null) {
            previous.next = this;
        }
    }

    public Token getNextToken() {
        return this.next;
    }

    void setNextToken(Token next) {
        if (this.next != null) {
            this.next.previous = null;
        }
        this.next = next;
        if (next != null) {
            next.previous = this;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.pattern.getName());
        buffer.append("(");
        buffer.append(this.pattern.getId());
        buffer.append("): \"");
        for (int i = 0; i < this.image.length(); ++i) {
            char chr = this.image.charAt(i);
            if (Character.isISOControl(chr) || i > 25 && this.image.length() > 30) {
                buffer.append("(...)");
                break;
            }
            buffer.append(chr);
        }
        buffer.append("\", line: ");
        buffer.append(this.startLine);
        buffer.append(", col: ");
        buffer.append(this.startColumn);
        return buffer.toString();
    }

    public String toShortString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('\"');
        for (int i = 0; i < this.image.length(); ++i) {
            char chr = this.image.charAt(i);
            if (Character.isISOControl(chr) || i > 25 && this.image.length() > 30) {
                buffer.append("(...)");
                break;
            }
            buffer.append(chr);
        }
        buffer.append('\"');
        if (this.pattern.getType() == 2) {
            buffer.append(" <");
            buffer.append(this.pattern.getName());
            buffer.append(">");
        }
        return buffer.toString();
    }
}

