/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.eyeprint.service.config;

import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.sql.DataSource;
import net.percederberg.mibble.MibLoaderException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.interunity.ep.license.LicenseObj;
import ru.interunity.ep.license.LicenseUtilSrv;
import ru.interunity.ep.snmp.mib.MIBParser;
import ru.interunity.ep.snmp.srv.XeroxCounterLoader;

@Configuration
public class EyeprintConfig {
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${mib.directory}")
    private String mibDirectory;

    @Bean
    public DataSource getDataSource() {
        DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create();
        dataSourceBuilder.driverClassName(this.driverClassName);
        dataSourceBuilder.url(this.url);
        dataSourceBuilder.username(this.username);
        dataSourceBuilder.password(this.password);
        return dataSourceBuilder.build();
    }

    @Bean(name={"licence"})
    public LicenseObj licenceObj() throws NoSuchPaddingException, IllegalBlockSizeException, IOException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        LicenseObj licenseObj = LicenseUtilSrv.getLicense();
        return licenseObj;
    }

    @Bean
    public MIBParser getMIBParser() throws MibLoaderException, IOException {
        return new MIBParser(new File(this.mibDirectory));
    }

    @Bean
    public XeroxCounterLoader getXeroxLoader(MIBParser parser) {
        return new XeroxCounterLoader(parser);
    }
}

