/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.widget.widgets;

import java.time.LocalDateTime;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import ru.interunity.ep.web.widget.IWidget;
import ru.interunity.ep.web.widget.WidgetData;
import ru.interunity.ep.web.widget.WidgetItem;
import ru.interunity.ep.web.widget.WidgetTemplate;

public class MonthlyPrintJobWidget
implements IWidget {
    public WidgetData getData(WidgetTemplate template) {
        HashMap<String, WidgetItem> map = new HashMap<String, WidgetItem>();
        List jobs = template.getPrintJobDao().getReportByDate(LocalDateTime.of(LocalDateTime.now().getYear(), Month.JANUARY, 1, 0, 0), LocalDateTime.of(LocalDateTime.now().getYear(), Month.DECEMBER, 31, 23, 59));
        Map<String, Long> montJobs = jobs.stream().collect(Collectors.groupingBy(date -> date.getJobStartTime().getMonth().getDisplayName(TextStyle.FULL_STANDALONE, Locale.getDefault()), Collectors.counting()));
        for (Map.Entry<String, Long> stat : montJobs.entrySet()) {
            map.put(stat.getKey(), WidgetItem.builder().itemColor("green").legendName(stat.getKey()).itemValue((double)stat.getValue().longValue()).build());
        }
        return WidgetData.builder().name("\u041e\u0431\u044a\u0435\u043c \u043f\u0435\u0447\u0430\u0442\u0438 \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c").widgetItems(map).build();
    }
}

