/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.srv;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import ru.interunity.ep.web.srv.SqlInit;

public class SqlInit {
    private static final Logger log = LoggerFactory.getLogger(SqlInit.class);
    private final JdbcTemplate jdbcTemplate;
    Connection con;
    Map<String, String> config;
    boolean iscon;

    public SqlInit(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        try {
            this.con = jdbcTemplate.getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDevListHtml() throws SQLException {
        Statement stGDL = this.con.createStatement();
        Object jwr = "";
        try (ResultSet rsGDL = stGDL.executeQuery("SELECT `printers`.*, INET_NTOA(`printers`.`ip`) as `ipS`, `iana`.`vendor` as `vn`,  timestamp(timestamp(`printers`.`date_last`)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST,  timestamp(timestamp(`printers`.`date_born`)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeBr FROM `printers` INNER JOIN `iana`ON `iana`.`id`=`printers`.`vendor` WHERE `printers`.`deleted`!=1 or `printers`.`deleted` is null  ORDER BY `printers`.`state` DESC");){
            while (rsGDL.next()) {
                int idDev = rsGDL.getInt("id");
                jwr = (String)jwr + "<div id='dev_" + idDev + "' class='elem";
                String stateDev = "";
                if (rsGDL.getInt("state") == 1) {
                    jwr = (String)jwr + " on";
                    stateDev = this.GetStatusDevice(idDev);
                } else {
                    jwr = (String)jwr + " off";
                    stateDev = "<img src='images/down.png' title='Offline' class='status'>";
                }
                jwr = (String)jwr + "'><table class='elemTable'><tr><td valign=top><img src='images/device.jpg' class='device on'>" + stateDev + "</td><td><table class='elemTableData'><tr><td class='name'><div class='nameCut' title='" + rsGDL.getString("name") + "'>" + rsGDL.getString("name") + "</div></td></tr><tr><td>" + rsGDL.getString("sn") + "</td></tr><tr><td>" + rsGDL.getString("counter") + "</td></tr><tr><td>" + rsGDL.getString("ipS") + "</td></tr><tr><td style='text-transform:uppercase; font-family: Courier;' >" + rsGDL.getString("macAddress") + "</td></tr></table></td><tr></table>";
                jwr = (String)jwr + this.getSupDevHtml(idDev) + "</div>";
            }
            rsGDL.close();
        }
        stGDL.close();
        return jwr;
    }

    public JSONObject getDevListArr() {
        JSONObject jSONObject;
        block16: {
            JSONObject jwr = new JSONObject();
            Statement stGDL = this.con.createStatement();
            try {
                try (ResultSet rsGDL = stGDL.executeQuery("SELECT `printers`.*, INET_NTOA(`printers`.`ip`) as `ipS`, `iana`.`vendor` as `vn`,  timestamp(timestamp(`printers`.`date_last`)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST,  timestamp(timestamp(`printers`.`date_born`)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeBr FROM `printers`INNER JOIN `iana`ON `iana`.`id`=`printers`.`vendor` WHERE `printers`.`deleted`!=1 or `printers`.`deleted` is null");){
                    while (rsGDL.next()) {
                        JSONArray line = new JSONArray();
                        line.add((Object)rsGDL.getString("id"));
                        line.add((Object)rsGDL.getString("macAddress"));
                        line.add((Object)rsGDL.getString("vendor"));
                        line.add((Object)rsGDL.getString("name"));
                        line.add((Object)rsGDL.getString("sn").trim());
                        line.add((Object)rsGDL.getString("ipS"));
                        line.add((Object)rsGDL.getString("9100"));
                        line.add((Object)rsGDL.getString("515"));
                        line.add((Object)rsGDL.getString("631"));
                        line.add((Object)rsGDL.getString("snmp"));
                        line.add((Object)rsGDL.getString("CommunityName"));
                        line.add((Object)rsGDL.getString("timeBr"));
                        line.add((Object)rsGDL.getString("timeST"));
                        line.add((Object)rsGDL.getString("state"));
                        line.add((Object)rsGDL.getString("deleted"));
                        line.add((Object)rsGDL.getString("printTech"));
                        line.add((Object)rsGDL.getString("format"));
                        line.add((Object)rsGDL.getString("color"));
                        line.add((Object)rsGDL.getString("counter"));
                        line.add((Object)rsGDL.getString("vn"));
                        jwr.put((Object)rsGDL.getString("id"), (Object)line);
                    }
                }
                jSONObject = jwr;
                if (stGDL == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (stGDL != null) {
                        try {
                            stGDL.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    log.error("Error in ", (Throwable)ex);
                    return jwr;
                }
            }
            stGDL.close();
        }
        return jSONObject;
    }

    public String agetProp() throws SQLException {
        Statement stGPL = this.con.createStatement();
        Object jwl = "<div id='out'><table border=0 cellspacing=0 cellpadding=0>\t\t\t<tr><td></td><td></td></tr>";
        try (ResultSet rsGPL = stGPL.executeQuery("SELECT `properties`.*FROM `properties` where description!=''");){
            while (rsGPL.next()) {
                jwl = (String)jwl + "<tr><td style='border-bottom:1px #aaa dotted;'>" + rsGPL.getString("description") + "</td><td style='border-bottom:1px #aaa dotted;'><input class='ips1' type='text' id='" + rsGPL.getString("parameter") + "' value='" + rsGPL.getString("prop_value") + "' class='im' ></td></tr>";
            }
        }
        jwl = (String)jwl + "</table></div>";
        return jwl;
    }

    public int getParam(String pramName) {
        try {
            Statement stGPV = this.con.createStatement();
            ResultSet rsGPV = stGPV.executeQuery("SELECT `prop_value` FROM `properties`WHERE `parameter` = '" + pramName + "'");
            if (rsGPV.next()) {
                return rsGPV.getInt("value");
            }
        }
        catch (SQLException sEx) {
            System.out.println(sEx.getMessage());
        }
        return 0;
    }

    public Map getParamForDevInfo(int idDev) {
        HashMap<String, String> listDevInfo = new HashMap<String, String>();
        try {
            Statement stGetDevParam = this.con.createStatement();
            ResultSet rsGetDevPAram = stGetDevParam.executeQuery("SELECT `macAddress`, `sn`,`name`, inet_ntoa(`ip`) as ips FROM `printers` WHERE id=" + idDev);
            if (rsGetDevPAram.next()) {
                listDevInfo.put("ip", rsGetDevPAram.getString("ips"));
                listDevInfo.put("name", rsGetDevPAram.getString("name"));
                listDevInfo.put("sn", rsGetDevPAram.getString("sn"));
                listDevInfo.put("mac", rsGetDevPAram.getString("macAddress"));
            }
            rsGetDevPAram.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return listDevInfo;
    }

    public Map getCodeDescr(String nameGroup) throws SQLException {
        HashMap<String, String> listDescr = new HashMap<String, String>();
        Statement stListDesc = this.con.createStatement();
        ResultSet rsListDescr = stListDesc.executeQuery("SELECT * FROM `codDesc` WHERE `group`='" + nameGroup + "'");
        while (rsListDescr.next()) {
            listDescr.put(rsListDescr.getString("idInGroup"), rsListDescr.getString("description"));
        }
        rsListDescr.close();
        stListDesc.close();
        return listDescr;
    }

    public String getSupReportsInDev(int idDev) throws SQLException {
        List listSupInDev = this.getSupInDev(idDev);
        Object forRet = "";
        for (int i = 0; i < listSupInDev.size(); ++i) {
            forRet = (String)forRet + this.getRepForSuppUnit(idDev, (String[])listSupInDev.get(i));
        }
        return forRet;
    }

    public List getSupInDev(int idDev) throws SQLException {
        Statement stGetSupInDev = this.con.createStatement();
        ResultSet rsGetSupInDev = stGetSupInDev.executeQuery("SELECT `type` , `color` FROM  `suppliesLog` WHERE devID='" + idDev + "' GROUP BY  `suppliesLog`.`type` ,  `suppliesLog`.`color`");
        1 listSupInDev = new /* Unavailable Anonymous Inner Class!! */;
        while (rsGetSupInDev.next()) {
            String[] typCol = new String[]{rsGetSupInDev.getString("type"), rsGetSupInDev.getString("color")};
            listSupInDev.add(typCol);
        }
        rsGetSupInDev.close();
        stGetSupInDev.close();
        return listSupInDev;
    }

    public String getRepForSuppUnit(int idDev, String[] typCol) throws SQLException {
        Statement stListVal = this.con.createStatement();
        ResultSet rsListVal = stListVal.executeQuery("SELECT  val, timestamp(timestamp(timeInsert)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, snSupp FROM `suppliesLog` where timeInsert>'2016-04-24' AND devID=" + idDev + " and type='" + typCol[0] + "' and color='" + typCol[1] + "' order by id  ");
        Map supTypeRef = this.getCodeDescr("PrtMarkerSuppliesType");
        double prev = 0.0;
        double all = 0.0;
        Object forRet = "";
        Object lineChanget = "";
        String oldSn = "";
        if (rsListVal.next()) {
            prev = rsListVal.getDouble("val");
            oldSn = rsListVal.getString("snSupp");
        }
        String dateFirstData = "";
        boolean dateSet = false;
        boolean first = true;
        while (rsListVal.next()) {
            double val;
            if (!dateSet) {
                dateFirstData = rsListVal.getString("timeST");
                dateSet = true;
            }
            double raz = 0.0;
            String valString = rsListVal.getString("val");
            if (valString.contains(",")) {
                valString = valString.replace(",", ".");
            }
            if (prev > (val = Double.parseDouble(valString))) {
                raz = prev - val;
            } else {
                if (first) {
                    lineChanget = "<tr class='changeS'><td colspan='3'>\u0417\u0430\u043c\u0435\u043d\u044b</td></tr>";
                    first = false;
                }
                lineChanget = (String)lineChanget + "<tr class='changeRow'><td></td><td>" + rsListVal.getString("timeST") + "</td><td>" + prev + "% -> " + val + "% ";
                if (!oldSn.isEmpty() || !rsListVal.getString("snSupp").equals("")) {
                    lineChanget = (String)lineChanget + " (" + oldSn + "-->>" + rsListVal.getString("snSupp") + ")";
                }
                lineChanget = (String)lineChanget + "</td></tr>";
                raz = 0.0;
            }
            all += raz;
            prev = val;
            oldSn = rsListVal.getString("snSupp");
        }
        if (all != 0.0) {
            forRet = (String)forRet + "<tr class='supUnit'><td><b>" + supTypeRef.get(typCol[0]) + "<b></td><td>" + typCol[1] + "</td><td> \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043e  " + all / 100.0 + " \u0435\u0434. (\u0417\u0430 \u043f\u0435\u0440\u0435\u0438\u043e\u0434 \u0441 " + dateFirstData + ")</td></tr>" + (String)lineChanget;
        }
        rsListVal.close();
        stListVal.close();
        return forRet;
    }

    public String getSupReportsAllDev() throws SQLException {
        Statement stGetListDev = this.con.createStatement();
        ResultSet rsGetListDev = stGetListDev.executeQuery("SELECT `id`, `name` FROM `printers`");
        Object forRet = "";
        while (rsGetListDev.next()) {
            forRet = (String)forRet + rsGetListDev.getString("name") + "<br>";
            forRet = (String)forRet + this.getSupReportsInDev(rsGetListDev.getInt("id"));
        }
        rsGetListDev.close();
        stGetListDev.close();
        return forRet;
    }

    public JSONObject getSup(int idDev, int type, String color) throws SQLException {
        Statement st = this.con.createStatement();
        ResultSet rsListParam = st.executeQuery("SELECT timestamp(timestamp(timeInsert)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, val FROM `suppliesLog` WHERE devId=" + idDev + " and color='" + color + "' and type=" + type + " and val>=0  ORDER BY timeInsert");
        JSONObject container = new JSONObject();
        int ind = 0;
        while (rsListParam.next()) {
            try {
                JSONArray item = new JSONArray();
                item.add((Object)rsListParam.getString("timeST"));
                item.add((Object)rsListParam.getString("val"));
                container.put((Object)ind, (Object)item);
                ++ind;
            }
            catch (Exception ex) {}
        }
        rsListParam.close();
        st.close();
        return container;
    }

    public JSONArray getSup(int idDev, int type, String color, String dateBegin, String dateEnd) throws SQLException {
        Statement st = this.con.createStatement();
        ResultSet rsListParam = st.executeQuery("SELECT timeInsert, timestamp(timestamp(timeInsert)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, val FROM `suppliesLog` WHERE devId=" + idDev + " and color='" + color + "' and type=" + type + " and val>=0 and `timeInsert`>'" + dateBegin + "' and `timeInsert`<'" + dateEnd + "'  ORDER BY timeInsert");
        JSONArray container = new JSONArray();
        while (rsListParam.next()) {
            try {
                JSONArray item = new JSONArray();
                item.add((Object)rsListParam.getString("timeST"));
                item.add((Object)Float.valueOf(rsListParam.getFloat("val")));
                container.add((Object)item);
            }
            catch (Exception ex) {}
        }
        rsListParam.close();
        st.close();
        return container;
    }

    public JSONArray getSup(int idDev, int type, String color, String date, int datetype) throws SQLException {
        Statement st = this.con.createStatement();
        Object query = "";
        if (datetype == 1) {
            query = "SELECT timeInsert, timestamp(timestamp(timeInsert)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, val FROM `suppliesLog` WHERE devId=" + idDev + " and color='" + color + "' and type=" + type + " and val>=0 and `timeInsert`>'" + date + "'  ORDER BY timeInsert";
        }
        if (datetype == 2) {
            query = "SELECT timeInsert, timestamp(timestamp(timeInsert)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, val FROM `suppliesLog` WHERE devId=" + idDev + " and color='" + color + "' and type=" + type + " and val>=0 and `timeInsert`<'" + date + "' ORDER BY timeInsert";
        }
        ResultSet rsListParam = st.executeQuery((String)query);
        JSONArray container = new JSONArray();
        while (rsListParam.next()) {
            try {
                JSONArray item = new JSONArray();
                item.add((Object)rsListParam.getString("timeST"));
                item.add((Object)Float.valueOf(rsListParam.getFloat("val")));
                container.add((Object)item);
            }
            catch (Exception ex) {}
        }
        rsListParam.close();
        st.close();
        return container;
    }

    public JSONObject getSupUnit(int idDev) throws SQLException {
        Statement st = this.con.createStatement();
        String query = "SELECT  `suppliesLog`.`type` as `type` ,  `suppliesLog`.`color` as `color` ,  `supplies_type`.`nameRus` as `nameRus` FROM  `suppliesLog` LEFT JOIN  `supplies_type` ON  `suppliesLog`.`type` =  `supplies_type`.`id`WHERE  `devId` = " + idDev + " AND `suppliesLog`.`type` not in (4, 10, 1) GROUP BY  `type` ,  `color`";
        ResultSet rsListParam = st.executeQuery(query);
        JSONArray container = new JSONArray();
        JSONObject jo = new JSONObject();
        int ind = 0;
        while (rsListParam.next()) {
            JSONArray item = new JSONArray();
            item.add((Object)rsListParam.getInt("type"));
            item.add((Object)rsListParam.getString("color"));
            item.add((Object)rsListParam.getString("nameRus"));
            container.add((Object)item);
            jo.put((Object)ind, (Object)item);
            ++ind;
        }
        return jo;
    }

    public JSONArray getCounterLog(int idDev) throws SQLException {
        Statement st = this.con.createStatement();
        String query = "SELECT `counterLog`.*, timestamp(timestamp(`timeSetValue`)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST FROM `counterLog`WHERE `idDev` =" + idDev + " ORDER BY `timeSetValue`";
        ResultSet rsListParam = st.executeQuery(query);
        JSONArray container = new JSONArray();
        while (rsListParam.next()) {
            JSONArray item = new JSONArray();
            item.add((Object)rsListParam.getString("timeST"));
            item.add((Object)rsListParam.getInt("counterValue"));
            container.add((Object)item);
        }
        return container;
    }

    public JSONArray getCounterLog(int idDev, String dateBegin, String dateEnd) throws SQLException {
        Statement st = this.con.createStatement();
        String query = "SELECT * FROM `counterLog`WHERE `idDev` =" + idDev + " and timeSetValue>'" + dateBegin + "' and timeSetValue<'" + dateEnd + "' ORDER BY `timeSetValue`";
        ResultSet rsListParam = st.executeQuery(query);
        JSONArray container = new JSONArray();
        while (rsListParam.next()) {
            JSONArray item = new JSONArray();
            item.add((Object)rsListParam.getString("timeSetValue"));
            item.add((Object)rsListParam.getInt("counterValue"));
            container.add((Object)item);
        }
        return container;
    }

    public JSONArray getCounterLog(int idDev, String date, int dateType) throws SQLException {
        Statement st = this.con.createStatement();
        Object query = "";
        if (dateType == 1) {
            query = "SELECT `counterLog`.*, timestamp(timestamp(`timeSetValue`)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST FROM `counterLog`WHERE `idDev` =" + idDev + " and timeSetValue>'" + date + "' ORDER BY `timeSetValue`";
        }
        if (dateType == 2) {
            query = "SELECT `counterLog`.*, timestamp(timestamp(`timeSetValue`)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST FROM `counterLog`WHERE `idDev` =" + idDev + " and timeSetValue<'" + date + "' ORDER BY `timeSetValue`";
        }
        ResultSet rsListParam = st.executeQuery((String)query);
        JSONArray container = new JSONArray();
        while (rsListParam.next()) {
            JSONArray item = new JSONArray();
            item.add((Object)rsListParam.getString("timeSetValue"));
            item.add((Object)rsListParam.getInt("counterValue"));
            container.add((Object)item);
        }
        return container;
    }

    public String getListNetDiap() throws SQLException {
        Object forRet = "";
        try (Statement st = this.con.createStatement();){
            ResultSet rs = st.executeQuery("SELECT * FROM `ips`");
            forRet = "";
            while (rs.next()) {
                forRet = (String)forRet + "<div class='line'><span id='del_" + rs.getString("id") + "' class='del'>x</span>&nbsp;&nbsp;<span id='range_" + rs.getString("id") + "' class='range'>" + rs.getString("ip_from") + "-" + rs.getString("ip_to") + "</span></div>";
            }
            rs.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return forRet;
    }

    public void addNetDiap(String ipFrom, String ipTo) throws SQLException {
        Statement st = this.con.createStatement();
        st.execute("INSERT INTO `ips` SET `ip_from`='" + ipFrom + "', `ip_to`='" + ipTo + "'");
        st.close();
    }

    public void delNetDiap(int idDiap) throws SQLException {
        Statement st = this.con.createStatement();
        st.execute("DELETE FROM `ips` WHERE `id`=" + idDiap);
        st.close();
    }

    public void setParam(String parameter, String value) throws SQLException {
        Statement st = this.con.createStatement();
        st.execute("UPDATE `properties` SET `prop_value`='" + value + "' WHERE `parameter`='" + parameter + "'");
        st.close();
    }

    public JSONArray GetAlert(String devId, String dateBegine, String dateEnd) throws SQLException {
        String query = "SELECT * FROM `alertLog` WHERE `devId`= ? AND `TimeInsert`< ?  AND `TimeInsert`> ? ";
        JSONArray arr = new JSONArray();
        this.jdbcTemplate.query(query, rs -> {
            while (rs.next()) {
                JSONArray row = new JSONArray();
                row.add((Object)rs.getString("TimeInsert"));
                row.add((Object)rs.getString("id"));
                row.add((Object)rs.getString("hrDeviceIndex"));
                row.add((Object)rs.getString("prtAlertIndex"));
                row.add((Object)rs.getString("prtAlertSeverityLevel"));
                row.add((Object)rs.getString("prtAlertTrainingLevel"));
                row.add((Object)rs.getString("prtAlertGroup"));
                row.add((Object)rs.getString("prtAlertGroupIndex"));
                row.add((Object)rs.getString("prtAlertLocation"));
                row.add((Object)rs.getString("prtAlertCode"));
                row.add((Object)rs.getString("prtAlertDescription"));
                row.add((Object)rs.getString("prtAlertTime"));
                row.add((Object)rs.getString("alertEnd"));
                row.add((Object)rs.getString("life"));
                arr.add((Object)row);
            }
        }, new Object[]{devId, dateEnd, dateBegine});
        return arr;
    }

    String getFullReport(int idDev) throws SQLException {
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery("SELECT * FROM suppliesLog WHERE Devid=" + idDev);
        Object forRet = "<table>";
        while (rs.next()) {
            String query;
            Statement stGetCounter = this.con.createStatement();
            ResultSet rsGetCounter = stGetCounter.executeQuery(query = "SELECT `counterValue`, `timeSetValue`  FROM counterLog WHERE idDev=" + idDev + " and timeSetValue <'" + rs.getString("timeInsert") + "' ORDER BY `timeSetValue` DESC LIMIT 1");
            if (!rsGetCounter.next()) continue;
            forRet = (String)forRet + "<tr><td>" + rs.getString("description") + "</td><td>" + rs.getString("val") + "</td><td>" + rs.getString("timeInsert") + "</td><td>" + rsGetCounter.getString("counterValue") + "</td><td>" + rsGetCounter.getString("timeSetValue") + "</td></tr>";
        }
        return (String)forRet + "</table>";
    }

    public String getCounterReport(String dateBegine, String dateEnd) throws SQLException {
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery("SELECT `printers`.`id` as `devId`, `printers`.`name` as `devName`, INET_NTOA(`printers`.`ip`) as `devIp`, `zap1`.`re`, `zap1`.`st`, `zap1`.`fn` FROM `printers` INNER JOIN (SELECT `idDev`, MAX(`counterValue`) as fn, MIN(`counterValue`) as st, (MAX(`counterValue`)-MIN(`counterValue`)) as `re` FROM `counterLog` WHERE `timeSetValue`>'2017-09-01' and `timeSetValue`<'2017-09-19' GROUP BY `idDev` ) `zap1`  ON `zap1`.`idDEv`=`printers`.`id` ORDER BY `re` DESC");
        String forRet = "<table class='kumulative'><thead><font size='+1'><b>\u0421\u0432\u043e\u0434\u043d\u044b\u0439 \u043e\u0442\u0447\u0435\u0442 \u0441 " + dateBegine.split(" ")[0] + " \u043f\u043e " + dateEnd.split(" ")[0] + "</b></font></thead>";
        while (rs.next()) {
            forRet = forRet + "<tr><td>" + rs.getString("devId") + "</td><td align='right'>" + rs.getString("devIp") + "</td><td>" + rs.getString("devName") + "</td><td>" + rs.getString("st") + "</td><td>" + rs.getString("fn") + "</td><td align='right'>" + rs.getString("re") + "</td></tr>";
        }
        return forRet + "</table>";
    }

    public String getSupDevHtml(int idDev) throws SQLException {
        HashMap<String, String> colorListRus = new HashMap<String, String>();
        colorListRus.put("magenta", "\u041f\u0443\u0440\u043f\u0443\u0440\u043d\u044b\u0439");
        colorListRus.put("yellow", "\u0416\u0435\u043b\u0442\u044b\u0439");
        colorListRus.put("cyan", "\u0413\u043e\u043b\u0443\u0431\u043e\u0439");
        colorListRus.put("clear", "\u041b\u0430\u043a");
        colorListRus.put("black", "\u0427\u0435\u0440\u043d\u044b\u0439");
        colorListRus.put("white", "\u0411\u0435\u043b\u044b\u0439");
        HashMap<String, String> colorListClass = new HashMap<String, String>();
        colorListClass.put("magenta", "tonerMagenta");
        colorListClass.put("yellow", "tonerYellow");
        colorListClass.put("cyan", "tonerCyan");
        colorListClass.put("clear", "tonerClear");
        colorListClass.put("black", "tonerBlack");
        colorListClass.put("white", "tonerWhite");
        Object tb = "<table class='elemTable'>";
        String query = "SELECT `suppliesLog`.`id`, `suppliesLog`.`type`, `suppliesLog`.`color`, `suppliesLog`.`val`  FROM `suppliesLog`\nRIGHT JOIN (SELECT max(`suppliesLog`.`id`) as `id` FROM `suppliesLog` WHERE `suppliesLog`.`devId`=" + idDev + " AND `suppliesLog`.`type` IN (3, 6, 5) GROUP BY `suppliesLog`.`type`, `suppliesLog`.`color`) as `zap1`\nON `suppliesLog`.`id`=`zap1`.`id`";
        Statement stGetSupDevHtml = this.con.createStatement();
        ResultSet rsGetSupDevHtml = stGetSupDevHtml.executeQuery(query);
        while (rsGetSupDevHtml.next()) {
            String val = "data-lowToner='false'";
            if (rsGetSupDevHtml.getInt("val") < this.getParam("alertSupp")) {
                val = "data-lowToner='true'";
            }
            tb = (String)tb + "<tr><td>" + colorListRus.get(rsGetSupDevHtml.getString("color").toLowerCase()) + "</td><td><div title='" + rsGetSupDevHtml.getInt("val") + "%' class='progress " + colorListClass.get(rsGetSupDevHtml.getString("color").toLowerCase()) + "' data-value='" + rsGetSupDevHtml.getInt("val") + "' " + val + " data-color='" + rsGetSupDevHtml.getString("color").toLowerCase() + "'></div></td></tr> ";
        }
        rsGetSupDevHtml.close();
        stGetSupDevHtml.close();
        return (String)tb + "</table>";
    }

    public String GetStatusDevice(int idDev) throws SQLException {
        Statement getStatusDevSt = this.con.createStatement();
        ResultSet getStatusDevRs = getStatusDevSt.executeQuery("SELECT * FROM am.alertLog WHERE `devId`=" + idDev + " AND `alertEnd` is NULL AND  `prtAlertTrainingLevel` IN (4, 5, 6);");
        String pathSrc = "'images/ok.png'";
        String altImg = "";
        while (getStatusDevRs.next()) {
            pathSrc = "'images/alert.png'";
            altImg = getStatusDevRs.getString("prtAlertDescription");
        }
        getStatusDevRs.close();
        getStatusDevSt.close();
        return "<img src=" + pathSrc + "  title='" + altImg + "' class='status'>";
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Connection getCon() {
        return this.con;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public boolean isIscon() {
        return this.iscon;
    }

    public void setCon(Connection con) {
        this.con = con;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public void setIscon(boolean iscon) {
        this.iscon = iscon;
    }
}

