/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import ru.interunity.ep.dto.CounterCounterReportItem;
import ru.interunity.ep.dto.CounterReportItem;
import ru.interunity.ep.job.collector.service.PrintJobService;
import ru.interunity.ep.web.dao.ReportDao;
import ru.interunity.ep.web.dto.ReportRs;

@Service
public class ReportService {
    private final ReportDao reportDao;
    private final PrintJobService printJobService;

    public List<CounterReportItem> getFullReport(LocalDateTime dateStart, LocalDateTime dateEnd) {
        return this.reportDao.getCounterReport(dateStart, dateEnd);
    }

    public ReportRs getCounter() {
        ReportRs.builder().headers(List.of(ReportRs.ReportHeader.builder().columnName("\u041f\u0440\u0438\u043d\u0442\u0435\u0440").fieldName("devName").columnType("string").build(), ReportRs.ReportHeader.builder().columnName("\u0421\u0447\u0435\u0442\u0447\u0438\u043a \u043e\u0431\u0449\u0438\u0439").fieldName("counter").columnType("integer").build())).build();
        return ReportRs.builder().build();
    }

    public ReportRs getJob(LocalDateTime dateStart, LocalDateTime dateEnd) {
        List rep = this.printJobService.getReportByDate(dateStart, dateEnd);
        return ReportRs.builder().headers(List.of(ReportRs.ReportHeader.builder().columnName("\u0414\u0430\u0442\u0430").fieldName("jobEndTime").columnType("string").build(), ReportRs.ReportHeader.builder().columnName("\u041f\u0440\u0438\u043d\u0442\u0435\u0440").fieldName("devName").columnType("string").build(), ReportRs.ReportHeader.builder().columnName("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c").fieldName("jobOwner").columnType("string").build())).items(rep).build();
    }

    public ReportRs getDeviceReport(LocalDateTime dateStart, LocalDateTime dateEnd) {
        ReportRs.ReportRsBuilder report = ReportRs.builder().headers(List.of(ReportRs.ReportHeader.builder().columnName("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435").columnType("string").fieldName("devname").build(), ReportRs.ReportHeader.builder().columnName("\u0418\u0414").columnType("integer").fieldName("devid").build(), ReportRs.ReportHeader.builder().columnName("\u041e\u0442\u043f\u0435\u0447\u0430\u0442\u043a\u043e\u0432").columnType("integer").fieldName("fn").build()));
        List items = this.reportDao.getCounterReport(dateStart, dateEnd).stream().map(CounterCounterReportItem::map).collect(Collectors.toList());
        report.items(items);
        return report.build();
    }

    public ReportService(ReportDao reportDao, PrintJobService printJobService) {
        this.reportDao = reportDao;
        this.printJobService = printJobService;
    }
}

