/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.service;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import ru.interunity.ep.dao.JobPriceDao;
import ru.interunity.ep.dao.ModelAndVendorDAO;
import ru.interunity.ep.dto.JobPriceDto;

@Service
public class JobPriceService {
    private final JobPriceDao jobPriceDao;
    private final ModelAndVendorDAO modelAndVendorDAO;
    private static final Logger log = LoggerFactory.getLogger(JobPriceService.class);

    public JobPriceService(JobPriceDao jobPriceDao, ModelAndVendorDAO modelAndVendorDAO) {
        this.jobPriceDao = jobPriceDao;
        this.modelAndVendorDAO = modelAndVendorDAO;
    }

    public List<JobPriceDto> getAllPrice() {
        return this.jobPriceDao.getAll();
    }

    public Integer deleteById(Integer id) {
        return this.jobPriceDao.deleteById(id);
    }

    public boolean addNewPrice(JobPriceDto price) {
        if ((this.jobPriceDao.checkPrinterId(price.getPrinterId()) || price.getPrinterId() == 0L) && this.modelAndVendorDAO.checkModelById(price.getModel())) {
            try {
                return this.jobPriceDao.addNewPrice(price) > 0;
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return false;
    }

    public Boolean updatePrice(JobPriceDto price) {
        if ((this.jobPriceDao.checkPrinterId(price.getPrinterId()) || price.getPrinterId() == 0L) && this.modelAndVendorDAO.checkModelById(price.getModel())) {
            try {
                return this.jobPriceDao.updatePrice(price) > 0;
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return false;
    }
}

