/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.PrintPermissionDto;

@Component
public class UserPrintPermissionDao {
    private final JdbcTemplate jdbcTemplate;

    public UserPrintPermissionDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<PrintPermissionDto> getAllUserPermission() {
        ArrayList<PrintPermissionDto> permissions = new ArrayList<PrintPermissionDto>();
        this.jdbcTemplate.query("SELECT id, username, print_permission, color_print_permission, duplex_permission FROM usr", rs -> {
            while (rs.next()) {
                permissions.add(PrintPermissionDto.builder().id(Integer.valueOf(rs.getInt("id"))).username(rs.getString("username")).printPermission(rs.getBoolean("print_permission")).colorPrintPermission(rs.getBoolean("color_print_permission")).duplexPermission(rs.getBoolean("duplex_permission")).build());
            }
            return null;
        });
        return permissions;
    }

    public Integer updatePermission(PrintPermissionDto permission) {
        return this.jdbcTemplate.update("UPDATE usr SET print_permission = ?, color_print_permission = ?, duplex_permission = ? WHERE id = ?", new Object[]{permission.isPrintPermission(), permission.isColorPrintPermission(), permission.isDuplexPermission(), permission.getId()});
    }

    public Integer updatePermissionByName(PrintPermissionDto permission) {
        String query = "UPDATE usr SET " + permission.getPermissionName() + " = ? WHERE id = ?";
        return this.jdbcTemplate.update(query, new Object[]{permission.isUniversalResolution(), permission.getId()});
    }
}

