/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import ru.interunity.ep.web.controller.DashBoardWidgetController;
import ru.interunity.ep.web.dto.UserGroupDto;
import ru.linologi.auth.dao.repos.UserRepository;
import ru.linologi.auth.dto.User;

@Component
public class UserGroupDao {
    private final JdbcTemplate jdbcTemplate;
    private final UserRepository repository;
    private static final Logger log = LoggerFactory.getLogger(DashBoardWidgetController.class);

    public UserGroupDao(JdbcTemplate jdbcTemplate, UserRepository repository) {
        this.jdbcTemplate = jdbcTemplate;
        this.repository = repository;
    }

    public UserGroupDto addNewGroup(UserGroupDto ugd) {
        Integer newGroupId = (Integer)this.jdbcTemplate.queryForObject("Insert INTO user_group(group_name, description) VALUES (?, ?) RETURNING id", Integer.class, new Object[]{ugd.getGroupName(), ugd.getDescription()});
        return UserGroupDto.builder().id(newGroupId).groupName(ugd.getGroupName()).description(ugd.getDescription()).build();
    }

    public List<UserGroupDto> getAllGroups() {
        ArrayList<UserGroupDto> userGroups = new ArrayList<UserGroupDto>();
        this.jdbcTemplate.query("SELECT * FROM user_group", rs -> {
            while (rs.next()) {
                userGroups.add(UserGroupDto.builder().id(Integer.valueOf(rs.getInt("id"))).groupName(rs.getString("group_name")).description(rs.getString("description")).build());
            }
            return null;
        });
        return userGroups;
    }

    public UserGroupDto getGroupById(Integer id) {
        UserGroupDto userGroup = UserGroupDto.builder().id(id).build();
        this.jdbcTemplate.query("SELECT * FROM user_group WHERE id =?", rs -> {
            if (rs.next()) {
                userGroup.setId(Integer.valueOf(rs.getInt("id")));
                userGroup.setGroupName(rs.getString("group_name"));
                userGroup.setDescription(rs.getString("description"));
            } else {
                userGroup.setId(Integer.valueOf(-1));
            }
            return null;
        }, new Object[]{id});
        return userGroup;
    }

    public Integer updateGroup(UserGroupDto ugd) {
        return this.jdbcTemplate.update("UPDATE user_group SET group_name = ?, description = ? WHERE id = ?", new Object[]{ugd.getGroupName(), ugd.getDescription(), ugd.getId()});
    }

    public Integer deleteGroupById(Integer id) {
        return this.jdbcTemplate.update("DELETE FROM user_group WHERE id = ?", new Object[]{id});
    }

    public Integer addUserGroupRelation(Integer userId, Integer groupId) {
        return this.jdbcTemplate.update("INSERT INTO users_group_relation(user_id, group_id) VALUES (?, ?)", new Object[]{userId, groupId});
    }

    public Integer deleteUserGroupRelation(Integer userId, Integer groupId) {
        return this.jdbcTemplate.update("DELETE FROM users_group_relation WHERE user_id = ? AND group_id = ?;", new Object[]{userId, groupId});
    }

    public Integer checkUserGroupRelation(Integer userId, Integer groupId) {
        return (Integer)this.jdbcTemplate.queryForObject("SELECT count(*) FROM  users_group_relation WHERE user_id = ? AND group_id = ?;", Integer.class, new Object[]{userId, groupId});
    }

    public List<UserGroupDto> getUserGroupsById(Long id) {
        ArrayList<UserGroupDto> groups = new ArrayList<UserGroupDto>();
        this.jdbcTemplate.query("SELECT * FROM users_group_relation WHERE user_id = ?", rs -> {
            while (rs.next()) {
                UserGroupDto group = this.getGroupById(Integer.valueOf(rs.getInt("group_id")));
                groups.add(group);
            }
            return null;
        }, new Object[]{id});
        return groups;
    }

    public List<User> getGroupUsersById(Integer groupId) {
        ArrayList<User> users = new ArrayList<User>();
        this.jdbcTemplate.query("SELECT * FROM users_group_relation WHERE group_id = ?", rs -> {
            while (rs.next()) {
                User user = this.repository.findById((Object)rs.getInt("user_id")).orElse(null);
                users.add(user);
            }
            return null;
        }, new Object[]{groupId});
        return users;
    }

    public List<UserGroupDto> getAllGroupsWithUsers() {
        List groups = this.getAllGroups();
        for (UserGroupDto ugd : groups) {
            ugd.setUsers(this.getGroupUsersById(ugd.getId()));
        }
        return groups;
    }

    public Map<Long, List<UserGroupDto>> getAllUsersWithGroup() {
        List users = this.repository.findAll();
        HashMap<Long, List<UserGroupDto>> usersWithGroups = new HashMap<Long, List<UserGroupDto>>();
        for (UserDetails user : users) {
            Long userId = ((User)user).getId();
            usersWithGroups.put(userId, this.getUserGroupsById(userId));
        }
        return usersWithGroups;
    }
}

